package org.simantics.event.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.event.ontology.EventResource;

/**
 * Request for getting all event logs from a model.
 * 
 * @author Tuukka Lehtonen
 */
public class AllEventLogs extends ResourceRead<Collection<Resource>> {

    public AllEventLogs(Resource model) {
        super(model);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        EventResource EVENT = EventResource.getInstance(graph);
        List<Resource> result = new ArrayList<Resource>();
        for (Resource eventLog : graph.syncRequest(new ObjectsWithType(resource, EVENT.HasEventLog, EVENT.EventLog))) {
            result.add(eventLog);
        }
        return result;
    }

}
