/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.export;

import com.lowagie.text.DocumentException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentSettings;
import org.simantics.document.DocumentUtils;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ExportClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.pdf.ExportPdfWriter;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.page.PageDesc;
import org.simantics.wiki.ui.language.MediaWikiLanguage;

public class ExportWikiPdf
implements ExportClass {
    static RecordType wikiOptions = new RecordType();
    MarkupParser markupParser = new MarkupParser();
    MediaWikiLanguage language = new MediaWikiLanguage();

    public ExportWikiPdf() {
        this.markupParser.setMarkupLanguage((MarkupLanguage)this.language);
    }

    public RecordType options(ExportContext ctx, Collection<String> contentUris) throws ExportException {
        return wikiOptions;
    }

    public List<String> validate(String contentUri, ExportContext context, Variant options) {
        return Collections.emptyList();
    }

    public void export(List<Content> contents, Object handle, ExportContext ctx, Variant options, IProgressMonitor monitor, MapList<Content, Content> attachmentMap) throws ExportException {
        ExportPdfWriter writer = (ExportPdfWriter)handle;
        try {
            for (Content content : contents) {
                Resource res = (Resource)ctx.session.syncRequest(Queries.resource((String)content.url));
                StringBuilder wikiSb = new StringBuilder();
                StringBuilder cssSb = new StringBuilder();
                DocumentUtils du = new DocumentUtils();
                du.getDocumentWikiTextRecursive(ctx.session, res, wikiSb, cssSb);
                DocumentSettings settings = du.getDocumentSettings((RequestProcessor)ctx.session, res);
                if (wikiSb.length() <= 0) continue;
                ExportPdfWriter.Page page = writer.createPage(PageDesc.A4);
                du.print((RequestProcessor)ctx.session, res, wikiSb.toString(), cssSb.toString(), settings, page.pdfWriter, page.document);
            }
        }
        catch (DatabaseException e) {
            throw new ExportException((Throwable)e);
        }
        catch (DocumentException e) {
            throw new ExportException((Throwable)e);
        }
    }

    Content findClosestContent(List<Content> contents, String uri) {
        Content result = null;
        int match = -1;
        for (Content c : contents) {
            if (!uri.startsWith(c.url) || c.url.length() <= match) continue;
            match = c.url.length();
            result = c;
        }
        return result;
    }

    public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
    }

    public void savePref(Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
    }

    public void loadPref(Variant options, Preferences contentScopeNode, Preferences workspaceScopePrefs) throws ExportException {
    }
}

