/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.Simantics;
import org.simantics.document.Activator;
import org.simantics.document.DocumentSettings;

public class PhantomJSDriver {
    public static File fileRef(String fileName) throws IOException {
        BundleContext context = Activator.getContext();
        Path path = new Path("/" + fileName);
        URL libURL = FileLocator.find((Bundle)context.getBundle(), (IPath)path, null);
        URL fileURL = FileLocator.toFileURL((URL)libURL);
        return new File(URLDecoder.decode(fileURL.getPath(), "UTF-8"));
    }

    public static String printCommand(String margin, String url, String outFile) throws IOException {
        try {
            File f = PhantomJSDriver.fileRef("print.js");
            String template = new String(Files.readAllBytes(f.toPath()));
            template = template.replace("%%url", url);
            template = template.replace("%%margin", margin);
            template = template.replace("%%file", outFile.replace("\\", "/"));
            return template;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static void print(String html, DocumentSettings settings, File output) throws IOException {
        File htmlFile = Simantics.getTempfile((String)"PhantomJSDriver", (String)"html");
        Files.write(htmlFile.toPath(), html.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        String browserUrl = htmlFile.toURI().toURL().toString();
        File script = Simantics.getTempfile((String)"PhantomJSDriver", (String)"script");
        String margin = "{left:\"" + settings.marginLeft + "mm\", right:\"" + settings.marginRight + "mm\", top:\"" + settings.marginTop + "mm\", bottom:\"" + settings.marginBottom + "mm\"}";
        String printCommand = PhantomJSDriver.printCommand(margin, browserUrl, output.getAbsolutePath());
        Files.write(script.toPath(), printCommand.getBytes(), new OpenOption[0]);
        PhantomJSDriver.execute(script);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean execute(File javascript) {
        try {
            File filePath = PhantomJSDriver.fileRef("phantomjs.exe");
            String[] args = new String[]{filePath.getAbsolutePath(), javascript.getAbsolutePath()};
            Process process = new ProcessBuilder(args).start();
            try {
                InputStream input = process.getInputStream();
                InputStreamReader reader = new InputStreamReader(input);
                while (true) {
                    try {
                        while (reader.ready()) {
                            reader.read();
                        }
                        int error = process.exitValue();
                        reader.close();
                        boolean bl = error == 0;
                        return bl;
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        Thread.sleep(100L);
                        continue;
                    }
                    break;
                }
            }
            finally {
                process.destroy();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }
}

