/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentResource;
import org.simantics.document.FileDocumentUtil;
import org.simantics.layer0.Layer0;

public class DocumentVersionUtils {
    public static void createNewVersion(WriteGraph graph, Resource oldDocument, Resource newDocument, Resource relation) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (graph.hasStatement(oldDocument, doc.HasNewerVersion)) {
            throw new DatabaseException("Document " + NameUtils.getSafeName((ReadGraph)graph, (Resource)oldDocument) + " has already new version");
        }
        Resource inverse = graph.getInverse(relation);
        Resource lib = graph.getSingleObject(oldDocument, inverse);
        String modeString = (String)graph.getPossibleRelatedValue(lib, doc.HasVersionType);
        VersionMode mode = VersionMode.FLAT;
        if (modeString != null) {
            mode = VersionMode.valueOf(modeString);
        }
        graph.claim(oldDocument, doc.HasNewerVersion, newDocument);
        graph.claim(lib, relation, newDocument);
        if (mode == VersionMode.TREE) {
            graph.deny(lib, relation, oldDocument);
            graph.claim(newDocument, relation, oldDocument);
        }
        FileDocumentUtil.createUniqueName(graph, newDocument);
    }

    public static void setVersion(WriteGraph graph, Resource document1, Resource document2, Resource versionRel) throws DatabaseException {
        Resource document2Ver;
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (!graph.getSingleType(document2, doc.Document).equals(graph.getSingleType(document1, doc.Document))) {
            return;
        }
        if (!versionRel.equals(doc.HasNewerVersion) && !versionRel.equals(doc.HasOlderVersion)) {
            throw new IllegalArgumentException("Unknow version relation + " + graph.getPossibleURI(versionRel));
        }
        Resource versionRelInv = graph.getInverse(versionRel);
        Resource r = document1;
        while (r != null) {
            if (r.equals(document2)) {
                return;
            }
            r = graph.getPossibleObject(r, versionRel);
        }
        r = document2;
        while (r != null) {
            if (r.equals(document1)) {
                return;
            }
            r = graph.getPossibleObject(r, versionRel);
        }
        Resource document1Ver = graph.getPossibleObject(document1, versionRel);
        if (document1Ver != null) {
            DocumentVersionUtils.unsetVersion(graph, document1, document1Ver, versionRel);
        }
        if ((document2Ver = graph.getPossibleObject(document2, versionRelInv)) != null) {
            DocumentVersionUtils.unsetVersion(graph, document2, document2Ver, versionRelInv);
        }
        graph.claim(document1, versionRel, document2);
        Resource lib = DocumentVersionUtils.getLib((ReadGraph)graph, document1);
        if (lib != null) {
            Resource relation = graph.getPossibleObject(lib, doc.HasLibraryRelation);
            String type = (String)graph.getPossibleRelatedValue(lib, doc.HasVersionType);
            if ("TREE".equals(type) && relation != null) {
                if (versionRel.equals(doc.HasOlderVersion)) {
                    graph.deny(document2, graph.getInverse(relation));
                    graph.claim(document1, relation, document2);
                } else {
                    graph.deny(document1, graph.getInverse(relation));
                    graph.claim(document2, relation, document1);
                }
            }
        }
    }

    public static void unsetVersion(WriteGraph graph, Resource document1, Resource document2, Resource versionRel) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        if (!versionRel.equals(doc.HasNewerVersion) && !versionRel.equals(doc.HasOlderVersion)) {
            throw new IllegalArgumentException("Unknow version relation + " + graph.getPossibleURI(versionRel));
        }
        graph.deny(document1, versionRel, document2);
        Resource lib = DocumentVersionUtils.getLib((ReadGraph)graph, document1);
        if (lib != null) {
            Resource relation = graph.getPossibleObject(lib, doc.HasLibraryRelation);
            String type = (String)graph.getPossibleRelatedValue(lib, doc.HasVersionType);
            if ("TREE".equals(type) && relation != null) {
                if (versionRel.equals(doc.HasOlderVersion)) {
                    graph.deny(document1, relation);
                    graph.claim(lib, relation, document2);
                    FileDocumentUtil.createUniqueName(graph, document2);
                } else {
                    graph.deny(document1, graph.getInverse(relation));
                    graph.claim(lib, relation, document1);
                    FileDocumentUtil.createUniqueName(graph, document1);
                }
            }
        }
    }

    private static Resource getLib(ReadGraph graph, Resource document) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        Resource r = document;
        while (true) {
            Resource lib;
            if ((lib = graph.getPossibleObject(r, l0.PartOf)) == null) {
                lib = graph.getPossibleObject(r, l0.IsOwnedBy);
            }
            if (lib == null) {
                lib = graph.getPossibleObject(r, l0.IsDependencyOf);
            }
            if (lib == null) {
                return null;
            }
            if (!graph.isInstanceOf(lib, doc.Document)) {
                return lib;
            }
            r = lib;
        }
    }

    public static enum VersionMode {
        FLAT,
        TREE;

    }
}

