/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.actions;

import java.io.File;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.simantics.DatabaseJob;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.document.FileDocumentUtil;
import org.simantics.document.ui.Activator;
import org.simantics.graphfile.util.GraphFileUtil;

/**
 * Action for exporting file based documents.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class ExportDocumentFolder implements ActionFactory {
	Resource relation;
	boolean useResourceNames;

	public ExportDocumentFolder(ReadGraph graph, String relationUri) throws DatabaseException {
		relation = graph.getResource(relationUri);
		useResourceNames = true;
	}

	public ExportDocumentFolder(ReadGraph graph, String relationUri, String useResourceNames) throws DatabaseException {
		relation = graph.getResource(relationUri);
		this.useResourceNames = useResourceNames.equals("true"); //$NON-NLS-1$
	}
	
	@Override
	public Runnable create(Object target) {

		if(!(target instanceof Resource))
			return null;

		final Resource resource = (Resource)target;

		return new Runnable() {
			@Override
			public void run() {
				Shell shell = Display.getCurrent().getActiveShell();
				DirectoryDialog dialog = new DirectoryDialog(shell,SWT.SAVE);
				String folderName = dialog.open();
				if (folderName == null) {
					return;
				}
				File folder = new File(folderName);
				int choice = -1;
				if (folder.list().length > 0) {
					MessageDialog messageDialog = new MessageDialog(shell, Messages.ExportDocumentFolder_FolderExport, null, NLS.bind(Messages.ExportDocumentFolder_SelectedFolder, folderName), MessageDialog.QUESTION, new String[]{Messages.ExportDocumentFolder_DeleteAndExport,Messages.ExportDocumentFolder_Overwrite, IDialogConstants.CANCEL_LABEL }, 2); //$NON-NLS-3$
					choice = messageDialog.open();
					if (choice == 2)
						return;
					
				}
				ExportJob job = new ExportJob(resource, folder, choice == 0);
				job.setUser(true);
				job.schedule();

			}
		};
	}
	
	private class ExportJob extends DatabaseJob {
		Resource resource;
		File folder;
		boolean clear = false;
		public ExportJob(Resource resource,File folder, boolean clear) {
			super(Messages.ExportDocumentFolder_ExportFolder);
			this.resource = resource;
			this.folder = folder;
			this.clear = clear;
		}
		@Override
		protected IStatus run(IProgressMonitor monitor) {
			try {
				monitor.beginTask(Messages.ExportDocumentFolder_ExportFolder, IProgressMonitor.UNKNOWN);
				if (clear) {
					GraphFileUtil.clearDirectoryStructure(folder);
					monitor.worked(1);
				}
				FileDocumentUtil.exportDocumentFolder(resource, folder, relation, useResourceNames, monitor);
				monitor.done();
				return new Status(IStatus.OK, Activator.PLUGIN_ID, Messages.ExportDocumentFolder_ActivatorFolderExported);
			} catch (Exception e) {
				monitor.done();
				return new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.ExportDocumentFolder_AcivatorCannotExport, e);
			}
		}
	}
}
