/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.actions;

import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.document.AddDocumentAction;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.dialogs.UrlDetailDialog;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;

/**
 * Action for adding URI-links as documents.
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class AddUrlDocumentWithDetail extends AddDocumentAction {

	public AddUrlDocumentWithDetail(ReadGraph graph, String relationUri)
			throws DatabaseException {
		super(graph, relationUri);
	}


	@Override
	public Runnable create(Object target) {
		if(!(target instanceof Resource))
			return null;
		final Resource resource = (Resource)target;
		return new Runnable() {
			
			@Override
			public void run() {
				final UrlDetailDialog dialog = new UrlDetailDialog(Display.getCurrent().getActiveShell(),resource);
				if (dialog.open() != InputDialog.OK) {
					dialog.getAnnotationConfigurator().dispose();
					return;
				}
				final String uriString = dialog.getUrl();
				final String name = dialog.getName();
				Simantics.getSession().asyncRequest(new WriteRequest() {
					@Override
					public void perform(WriteGraph graph)
							throws DatabaseException {
					    graph.markUndoPoint();
					    Resource urlDocument = doAddUrl(graph, name, uriString);
					    linkDocument(graph, resource, urlDocument);
						dialog.getAnnotationConfigurator().apply(graph,urlDocument);
					}
				}, e -> {
					dialog.getAnnotationConfigurator().dispose();
					if (e != null)
						ExceptionUtils.logAndShowError("Cannot add URL link.", e); //$NON-NLS-1$
				});
			}
		};
	}

	private Resource doAddUrl(WriteGraph graph, String name, String uriString) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Layer0 l0 = Layer0.getInstance(graph);
        DocumentResource doc = DocumentResource.getInstance(graph);
        Resource urlDocument = graph.newResource();
        graph.claim(urlDocument, l0.InstanceOf, doc.UrlDocument);
        graph.claimLiteral(urlDocument, l0.HasName, name);
        graph.claimLiteral(urlDocument, doc.HasUrl, uriString);
        return urlDocument;
	}
	
	public static Resource addUrlDocumentWithDetailSCL(WriteGraph graph, Resource target, String name, String uriString) throws DatabaseException {
	    AddUrlDocumentWithDetail urlDocument = new AddUrlDocumentWithDetail(graph, "http://www.simantics.org/Layer0-1.1/ConsistsOf"); //$NON-NLS-1$
	    Resource urlResource = urlDocument.doAddUrl(graph, name, uriString);
	    urlDocument.linkDocument(graph, target, urlResource);
	    return urlResource;
	}

	
//	@Override
//	public Runnable create(Object target) {
//
//		if(!(target instanceof Resource))
//			return null;
//
//		final Resource resource = (Resource)target;
//
//		return new Runnable() {
//			@Override
//			public void run() {
//				InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Add URL", "Input URL", "", new URLValidator());
//				if (dialog.open() != InputDialog.OK)
//					return;
//				final String uriString = dialog.getValue();
//				Simantics.getSession().asyncRequest(new WriteRequest() {
//					
//					@Override
//					public void perform(WriteGraph graph) throws DatabaseException {
//						Layer0 l0 = Layer0.getInstance(graph);
//						DocumentResource doc = DocumentResource.getInstance(graph);
//						Resource urlDocument = graph.newResource();
//						graph.claim(urlDocument, l0.InstanceOf, doc.UrlDocument);
//						graph.claimLiteral(urlDocument, l0.HasName, uriString);
//						graph.claimLiteral(urlDocument, doc.HasUrl, uriString);
//						
//						if (graph.isInstanceOf(resource, doc.UrlDocument)) {
//							if (graph.hasStatement(resource, doc.HasNewerVersion))
//								throw new DatabaseException("Document " + NameUtils.getSafeName(graph, resource) +" has already new version");
//							// adding a new revision
//							Resource inverse = graph.getInverse(relation);
//							Resource lib = graph.getSingleObject(resource, inverse);
//							graph.claim(lib, relation, urlDocument);
//							graph.claim(resource, doc.HasNewerVersion, urlDocument);
//						} else {
//							// adding to a library
//							graph.claim(resource, relation, urlDocument);
//						}
//					}
//				},new Callback<DatabaseException>() {
//					
//					@Override
//					public void run(DatabaseException parameter) {
//						if (parameter != null) {
//							ExceptionUtils.logAndShowError("Cannot add URL link.", parameter);
//						}
//						
//					}
//				});
//				
//			}
//		};
//	}
}
