/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class OpenEntityDocumentAdapter extends AbstractResourceEditorAdapter {

    private static final String EDITOR_ID = "org.simantics.document.ui.editor"; //$NON-NLS-1$

    public OpenEntityDocumentAdapter() throws MalformedURLException {
        super(Messages.OpenEntityDocumentAdapter_DocumentEditor, ImageDescriptor.createFromURL(new URL(
                "platform:/plugin/com.famfamfam.silk/icons/table.png"))); //$NON-NLS-1$
    }

    protected String getEditorId() {
        return EDITOR_ID;
    }

    @Override
    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        return g.isInstanceOf(r, Layer0.getInstance(g).Entity);
    }

    @Override
    public void openEditor(final Resource r) throws Exception {
        Simantics.getSession().asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph graph) throws DatabaseException {

                final Resource rr = getActualResource(graph, r);

                Variable variable = graph.adapt(rr, Variable.class);
                final Resource model = Variables.getModel(graph, variable);
                final RVI rvi = variable.getRVI(graph);

//                System.out.println("rr: " + NameUtils.getSafeName(graph, rr, true));
//                System.out.println("DOC URI: " + variableURI);
//                System.out.println("MODEL URI: " + modelURI);
//                System.out.println("RVI: " + RVI);

                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            String editorId = getEditorId();
                            if (rvi != null)
                                WorkbenchUtils.openEditor(editorId, new ResourceEditorInput2(editorId, rr, model, rvi));
//                            else 
//                                WorkbenchUtils.openEditor(editorId, new ResourceEditorInput2(editorId, rr, variableURI, null));
                        } catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    protected Resource getActualResource(ReadGraph graph, Resource r) {
        return r;
    }

}
