/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.swt.core.widget;

import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.document.server.client.WidgetData;
import org.simantics.document.server.io.CommandContext;
import org.simantics.document.server.io.CommandContextImpl;
import org.simantics.document.server.io.CommandContextMutable;
import org.simantics.document.server.io.ICommand;
import org.simantics.document.swt.core.SWTDocument;
import org.simantics.document.swt.core.base.PropertyWidgetManager;
import org.simantics.utils.datastructures.Pair;

public class ExplorerListener implements Listener {

    private WidgetData wd;
    private List<Pair<WidgetData, ICommand>> data;

    public ExplorerListener(WidgetData wd, List<Pair<WidgetData, ICommand>> data) {
        this.wd = wd;
        this.data = data;
    }

    @Override
    public void handleEvent(Event event) {
        switch (event.type) {
        case SWT.Selection:
            if (event.detail == SWT.CHECK && event.item != null) {
                TreeItem item = (TreeItem) event.item;
                NodeContext ctx = (NodeContext)item.getData();
                Object value = ctx.getConstant(BuiltinKeys.INPUT);

                boolean checked = item.getChecked();

                CommandContextMutable context = new CommandContextImpl();
                context.putValue("event", "onCheck");
                context.putValue("checked", checked);
                context.putValue("item", value);

                if (!data.isEmpty()) {
                    ((SWTDocument)wd.document).handleCommands(data, context, event.widget);
                }

                CommandContext ret = PropertyWidgetManager.sendEvent((SWTDocument)wd.document, wd, "onCheck", event.widget, context);
            }
            break;
        }
    }

}