package org.simantics.document.export;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.simantics.wiki.ui.language.MediaWikiLanguage;
import org.osgi.service.prefs.Preferences;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.RecordType;
import org.simantics.db.Resource;
import org.simantics.db.common.request.Queries;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.DocumentSettings;
import org.simantics.document.DocumentUtils;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ExportClass;
import org.simantics.export.core.manager.Content;
import org.simantics.export.core.pdf.ExportPdfWriter;
import org.simantics.export.core.pdf.ExportPdfWriter.Page;
import org.simantics.utils.datastructures.MapList;
import org.simantics.utils.page.PageDesc;

import com.lowagie.text.DocumentException;

public class ExportWikiPdf implements ExportClass {

	static RecordType wikiOptions = new RecordType();
	
	MarkupParser markupParser;
	MediaWikiLanguage language;
	
	public ExportWikiPdf() {
		markupParser = new MarkupParser();
		language = new MediaWikiLanguage();
		markupParser.setMarkupLanguage(language);
	}
	
	@Override
	public RecordType options(ExportContext ctx, Collection<String> contentUris) throws ExportException {
		return wikiOptions;
	}

	@Override
	public List<String> validate(String contentUri, ExportContext context, Variant options) {
		return Collections.emptyList();
	}

	@Override
	public void export(List<Content> contents, Object handle, ExportContext ctx, Variant options, IProgressMonitor monitor, MapList<Content, Content> attachmentMap) throws ExportException {
		
		final ExportPdfWriter writer = (ExportPdfWriter) handle;
		
		try {
			
			for(Content content : contents) {
				
				Resource res = ctx.session.syncRequest( Queries.resource(content.url) );
			
				StringBuilder wikiSb = new StringBuilder();
				StringBuilder cssSb = new StringBuilder();

				DocumentUtils du = new DocumentUtils();
				du.getDocumentWikiTextRecursive(ctx.session, res, wikiSb, cssSb);
				DocumentSettings settings = du.getDocumentSettings(ctx.session, res);

				if ( wikiSb.length()>0 ) {
					Page page = writer.createPage(PageDesc.A4);
					du.print(ctx.session, res, wikiSb.toString(), cssSb.toString(), settings, page.pdfWriter, page.document);
				}

			}

		} catch (DatabaseException e) {
			throw new ExportException( e ); 
		} catch (DocumentException e) {
			throw new ExportException( e ); 
		}
	}
	
	Content findClosestContent(List<Content> contents, String uri) {
		Content result = null;
		int match = -1;
		for ( Content c : contents ) {
			if ( uri.startsWith(c.url) ) {
				if ( c.url.length()>match ) {
					match = c.url.length();
					result = c;
				}
			}
		}
		return result;
	}

	@Override
	public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
	}

	@Override
	public void savePref(Variant options, Preferences contentScopePrefs, Preferences workspaceScopePrefs) throws ExportException {
	}

	@Override
	public void loadPref(Variant options, Preferences contentScopeNode, Preferences workspaceScopePrefs) throws ExportException {
	}
	
}
