/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.state;

import java.io.IOException;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.document.server.state.State;
import org.simantics.document.server.state.StateNode;
import org.simantics.document.server.state.StateNodeManagerSupport;
import org.simantics.document.server.state.StatePropertyNode;
import org.simantics.document.server.state.StateRootNode;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.toolkit.db.StandardVariableNodeManager;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateNodeManager
extends StandardVariableNodeManager<StateNode, StateNodeManagerSupport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StateNodeManager.class);

    public StateNodeManager(StandardRealm<StateNode, StateNodeManagerSupport> realm, StateNode root) {
        super(realm, (Object)root);
    }

    public void setState(String key, Object value) {
        try {
            this.getRealm().syncExec(() -> {
                try {
                    StateRootNode rootNode = (StateRootNode)this.getRoot();
                    StatePropertyNode propertyNode = rootNode.getProperty(key);
                    if (propertyNode == null) {
                        this.setValue(rootNode.createProperty(key), value, (Binding)Bindings.OBJECT);
                        this.refreshVariable(rootNode);
                    } else {
                        this.setValue(propertyNode, value, (Binding)Bindings.OBJECT);
                    }
                }
                catch (NodeManagerException e) {
                    LOGGER.error("Failed to set state.", (Throwable)e);
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error("Setting state was interrupted.", (Throwable)e);
        }
    }

    public byte[] serialize() {
        byte[][] result = new byte[1][];
        try {
            this.getRealm().syncExec(() -> {
                State state = new State();
                StateRootNode root = (StateRootNode)this.getRoot();
                for (StateNode node : root.getProperties().values()) {
                    StatePropertyNode property = (StatePropertyNode)node;
                    try {
                        Binding binding = Bindings.getInstanceBinding((Object)property.getValue());
                        if (binding == null) continue;
                        state.properties.put(property.getName(), new Variant(binding, property.getValue()));
                    }
                    catch (BindingConstructionException bindingConstructionException) {}
                }
                try {
                    byArray[0] = Bindings.getSerializerUnchecked((Binding)State.BINDING).serialize((Object)state);
                }
                catch (IOException | RuntimeSerializerConstructionException throwable) {}
            });
        }
        catch (InterruptedException e) {
            LOGGER.error("Serializing state was interrupted.", (Throwable)e);
        }
        return result[0];
    }

    public void deserialize(byte[] bytes) {
        try {
            this.getRealm().syncExec(() -> {
                StateRootNode rootNode = (StateRootNode)this.getRoot();
                rootNode.clear();
                try {
                    State state = (State)Bindings.getSerializer((Binding)State.BINDING).deserialize(bytes);
                    for (Map.Entry<String, Variant> entry : state.properties.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue().getValue();
                        try {
                            this.setValue(rootNode.createProperty(key), value, (Binding)Bindings.OBJECT);
                        }
                        catch (NodeManagerException e) {
                            LOGGER.error("Failed to deserialize state.", (Throwable)e);
                        }
                    }
                    this.refreshVariable(rootNode);
                }
                catch (IOException e1) {
                    LOGGER.error("Failed to deserialize state.", (Throwable)e1);
                }
                catch (SerializerConstructionException e1) {
                    LOGGER.error("Failed to deserialize state.", (Throwable)e1);
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error("Deserializing state was interrupted.", (Throwable)e);
        }
    }

    public void clearState() {
        try {
            this.getRealm().syncExec(() -> {
                StateRootNode rootNode = (StateRootNode)this.getRoot();
                rootNode.clear();
                this.refreshVariable(rootNode);
            });
        }
        catch (InterruptedException e) {
            LOGGER.error("Clearing state was interrupted.", (Throwable)e);
        }
    }

    public void removeState(String key) {
        try {
            this.getRealm().syncExec(() -> {
                StateRootNode rootNode = (StateRootNode)this.getRoot();
                if (rootNode.removeProperty(key)) {
                    this.refreshVariable(rootNode);
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.error("Removing state was interrupted.", (Throwable)e);
        }
    }
}

