/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.List;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.RowContentProvider;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.templates.ReportWriter;

public abstract class TableReportWriter<T>
implements ReportWriter<T> {
    private List<RowContentProvider<T>> lineContentProviders = new ArrayList<RowContentProvider<T>>();
    private List<RowContentProvider<T>> cellContentProviders = new ArrayList<RowContentProvider<T>>();
    TextItem[] line = new TextItem[1];

    public void addLineProvider(RowContentProvider<T> provider) {
        this.lineContentProviders.add(provider);
    }

    public void addCellProvider(RowContentProvider<T> provider) {
        this.cellContentProviders.add(provider);
    }

    public void clearProviders() {
        this.lineContentProviders.clear();
        this.cellContentProviders.clear();
    }

    @Override
    public void write(T previous, T current, T next, Document writer) throws Exception {
        for (RowContentProvider<T> cp : this.lineContentProviders) {
            this.line[0] = writer.newItem(TextItem.class, new String[0]);
            cp.setText(writer, previous, current, next, this.line);
            if (this.line[0].getText() == null || this.line[0].getText().length() <= 0) continue;
            Table table = writer.getCurrentElement(Table.class);
            Document.TextSize size = table.getTextSize();
            table.setTextSize(Document.TextSize.MEDIUM);
            table.writeRowItem(this.line[0]);
            table.setTextSize(size);
        }
        TextItem[] text = new TextItem[writer.getCurrentElement(Table.class).getColumns().size()];
        for (RowContentProvider<T> cp : this.cellContentProviders) {
            cp.setText(writer, previous, current, next, text);
        }
        int i = 0;
        while (i < text.length) {
            if (text[i] != null) {
                writer.getCurrentElement(Table.class).writeRowItem(text);
                break;
            }
            ++i;
        }
    }
}

