/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report.templates;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.RowContentProvider;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TableOfContents;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.report.templates.IndexQueryReport;
import org.simantics.document.linking.report.templates.Messages;
import org.simantics.document.linking.report.templates.NestedComparator;
import org.simantics.document.linking.report.templates.SourceParentDiagramComparator;
import org.simantics.document.linking.report.templates.SourceParentHierarchyComparator;
import org.simantics.document.linking.report.templates.SourceReferenceComparator;
import org.simantics.document.linking.utils.SourceLinkUtil;

public class DocumentStructureWriter
extends IndexQueryReport {
    ReadGraph graph;
    Resource model;
    Map<Object, Object> context;
    DocumentLink sl;
    Comparator<Resource> referenceComparator;
    Comparator<Resource> parentComparator;
    SourceParentDiagramComparator diagramComparator;

    @Override
    public void sort(List<Resource> list) throws DatabaseException {
        NestedComparator<Resource> comp = new NestedComparator<Resource>();
        comp.addComparator(this.referenceComparator);
        comp.addComparator(this.parentComparator);
        Collections.sort(list, comp);
    }

    @Override
    public String getName() {
        return "Document Structure";
    }

    @Override
    public void start(ReadGraph graph, Resource model, Document writer, Map<Object, Object> context) throws Exception {
        super.start(graph, model, writer, context);
        this.context = context;
        DocumentTitlePage titlePage = writer.newElement(DocumentTitlePage.class, new String[0]);
        titlePage.writeTitle(graph, context);
        writer.newElement(TableOfContents.class, new String[0]);
        Table table = writer.newElement(Table.class, "toc");
        table.addColumn("Name", 0.2);
        table.addColumn("Attribute", 0.35);
        table.addColumn("Value", 0.15);
        table.addColumn("Comment", 0.3);
        this.graph = graph;
        this.sl = DocumentLink.getInstance((ReadGraph)graph);
        this.model = model;
        this.referenceComparator = new SourceReferenceComparator(graph, model);
        this.parentComparator = new SourceParentHierarchyComparator(graph, model);
        this.diagramComparator = new SourceParentDiagramComparator(graph, model);
        this.clearProviders();
        LinkContentProvider linkContentProvider = new LinkContentProvider();
        HierarchyContentProvider hierarchyContentProvider = new HierarchyContentProvider(linkContentProvider);
        this.addLineProvider(hierarchyContentProvider);
        this.addCellProvider(linkContentProvider);
    }

    private class HierarchyContentProvider
    implements RowContentProvider<Resource> {
        private LinkContentProvider linkContentProvider;

        public HierarchyContentProvider(LinkContentProvider linkContentProvider) {
            this.linkContentProvider = linkContentProvider;
        }

        @Override
        public void setText(Document writer, Resource previous, Resource current, Resource next, TextItem[] row) throws Exception {
            boolean writeDoc = false;
            boolean writeDiag = false;
            boolean writeToc = false;
            Table table = writer.getCurrentElement(Table.class);
            if (previous == null) {
                writeDoc = true;
                writeDiag = true;
                writeToc = true;
            } else if (writer.getCurrentLine() == 1) {
                writeDoc = true;
                writeDiag = true;
                writeToc = DocumentStructureWriter.this.referenceComparator.compare(previous, current) != 0;
            } else if (DocumentStructureWriter.this.referenceComparator.compare(previous, current) != 0) {
                writeDoc = true;
                writeDiag = true;
                writeToc = true;
                this.linkContentProvider.forceLabel = true;
            } else if (DocumentStructureWriter.this.diagramComparator.compare(previous, current) != 0) {
                writeDiag = true;
                this.linkContentProvider.forceLabel = true;
            }
            if (writeDoc) {
                if (writer.getAvailableLines() < 8) {
                    writer.nextPage();
                    table = writer.nextElement(Table.class, "toc");
                } else if (writer.getCurrentLine() > 2) {
                    table = writer.nextElement(Table.class, "toc");
                }
                Resource doc2 = SourceLinkUtil.getReferredDocument(DocumentStructureWriter.this.graph, current);
                TextItem label = null;
                label = doc2 != null ? DocumentStructureWriter.this.getDocumentItem(doc2) : DocumentStructureWriter.this.getNonExistingDocumentItem();
                if (writeToc) {
                    TableOfContents toc = writer.getCurrentElement(TableOfContents.class);
                    toc.addTocElement(label.getText(), table);
                }
                table.setTitle(label);
            }
            if (writeDiag) {
                Resource parent;
                List<Resource> path;
                if (writer.getAvailableLines() < 3) {
                    writer.nextPage();
                }
                if ((path = SourceLinkUtil.getDiagramPath(DocumentStructureWriter.this.graph, DocumentStructureWriter.this.model, parent = DocumentStructureWriter.this.graph.getSingleObject(current, DocumentStructureWriter.this.sl.hasSource_Inverse))) != null) {
                    Document.TextSize size = table.getTextSize();
                    table.setTextSize(Document.TextSize.MEDIUM);
                    table.writeRow("  " + DocumentStructureWriter.this.diagramComparator.getText(path.get(path.size() - 1)));
                    table.setTextSize(size);
                }
            }
        }
    }

    private class LinkContentProvider
    implements RowContentProvider<Resource> {
        private boolean forceLabel = false;

        private LinkContentProvider() {
        }

        @Override
        public void setText(Document writer, Resource previous, Resource source, Resource next, TextItem[] text) throws Exception {
            String comment;
            Resource holder = DocumentStructureWriter.this.graph.getSingleObject(source, DocumentStructureWriter.this.sl.hasSource_Inverse);
            if (this.forceLabel || previous == null || !DocumentStructureWriter.this.graph.getSingleObject(previous, DocumentStructureWriter.this.sl.hasSource_Inverse).equals(DocumentStructureWriter.this.graph.getSingleObject(source, DocumentStructureWriter.this.sl.hasSource_Inverse))) {
                String holderName = NameUtils.getSafeLabel((ReadGraph)DocumentStructureWriter.this.graph, (Resource)holder);
                if (holderName.length() == 0) {
                    holderName = NameUtils.getSafeName((ReadGraph)DocumentStructureWriter.this.graph, (Resource)holder);
                }
                text[0] = writer.newItem(TextItem.class, new String[0]);
                text[0].setText(holderName);
                this.forceLabel = false;
            }
            if (DocumentStructureWriter.this.graph.isInstanceOf(source, DocumentStructureWriter.this.sl.FunctionalSource)) {
                Resource relation = DocumentStructureWriter.this.graph.getPossibleObject(source, DocumentStructureWriter.this.sl.consernsRelation);
                text[1] = writer.newItem(TextItem.class, new String[0]);
                if (relation != null) {
                    String relationName = NameUtils.getSafeLabel((ReadGraph)DocumentStructureWriter.this.graph, (Resource)relation);
                    if (relationName.length() == 0) {
                        relationName = NameUtils.getSafeName((ReadGraph)DocumentStructureWriter.this.graph, (Resource)relation);
                    }
                    Object value = DocumentStructureWriter.this.graph.getPossibleRelatedValue(holder, relation);
                    text[1].setText(relationName);
                    if (value != null) {
                        text[2] = writer.newItem(TextItem.class, new String[0]);
                        text[2].setText(SourceLinkUtil.getValueString(value));
                    }
                } else {
                    text[1].setText(Messages.DocumentStructureWriter_ErrorInPropertyReference);
                }
            }
            if ((comment = (String)DocumentStructureWriter.this.graph.getPossibleRelatedValue(source, DocumentStructureWriter.this.sl.hasSourceComment)) != null) {
                text[3] = writer.newItem(TextItem.class, new String[0]);
                text[3].setText(comment);
            }
        }
    }
}

