/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.report;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentElement;
import org.simantics.document.linking.report.DocumentLine;
import org.simantics.document.linking.report.TableColumn;
import org.simantics.document.linking.report.templates.CustomizableContentProvider;
import org.simantics.document.linking.report.templates.ReportWriter;
import org.simantics.document.linking.report.templates.custom.CustomizableContent;

public abstract class DocumentTitlePage
implements DocumentElement {
    public void writeTitle(ReadGraph graph, Map<Object, Object> context) throws Exception {
        ReportWriter reportWriter = (ReportWriter)context.get(ReportWriter.class);
        CustomizableContent content = null;
        if (reportWriter instanceof CustomizableContentProvider) {
            content = ((CustomizableContentProvider)((Object)reportWriter)).getContent("Title");
        }
        if (content == null) {
            this.writeTitle(this.getDefaultLines(graph, (Resource)context.get("model"), (String)context.get("DocumentName")));
        } else {
            List<DocumentLine> lines = content.getLines(graph, (Resource)context.get("model"), context);
            this.writeTitle(lines);
        }
    }

    protected abstract void writeTitle(List<DocumentLine> var1) throws Exception;

    public List<DocumentLine> getDefaultLines(ReadGraph graph, Resource model, String documentName) throws DatabaseException {
        ArrayList<DocumentLine> result = new ArrayList<DocumentLine>();
        String modelName = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)model);
        if (modelName.length() == 0) {
            modelName = NameUtils.getSafeName((ReadGraph)graph, (Resource)model);
        }
        Date date = new Date(System.currentTimeMillis());
        String dateString = DateFormat.getDateTimeInstance().format(date);
        result.add(new DocumentLine(modelName, new Object[]{TableColumn.Alignment.class, TableColumn.Alignment.CENTER, Document.TextSize.class, Document.TextSize.HUGE}));
        result.add(new DocumentLine(documentName, new Object[]{TableColumn.Alignment.class, TableColumn.Alignment.CENTER, Document.TextSize.class, Document.TextSize.HUGE}));
        result.add(new DocumentLine(dateString, new Object[]{TableColumn.Alignment.class, TableColumn.Alignment.CENTER, Document.TextSize.class, Document.TextSize.LARGE}));
        return result;
    }
}

