/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ge.Constants;
import org.simantics.document.linking.ge.Messages;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.ArrayMap;

public class VariableLabelRule
implements LabelRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public Map<String, String> getLabel(ReadGraph graph, Object content) throws DatabaseException {
        Variable variable = (Variable)content;
        Resource node = variable.getPossibleRepresents(graph);
        if (node == null) {
            return null;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        Object[] keys = Constants.SOURCE_COLUMN_KEYS;
        Object[] labels = new String[keys.length];
        if (graph.isInstanceOf(node, sl.Source)) {
            Resource reference = SourceLinkUtil.getReferredDocument(graph, node);
            String comment = (String)graph.getPossibleRelatedValue(node, sl.hasSourceComment);
            labels[0] = "";
            labels[1] = "";
            String string = labels[3] = comment != null ? comment : "";
            labels[2] = reference != null ? (SourceLinkUtil.isValidReference(graph, reference) ? NameUtils.getSafeLabel((ReadGraph)graph, (Resource)reference) : Messages.VariableLabelRule_DeletedReference) : (graph.getPossibleRelatedValue(node, sl.hasSourceReferenceURI, (Binding)Bindings.STRING) != null ? Messages.VariableLabelRule_ReferencesDoesNotExists : Messages.VariableLabelRule_ReferencesHasNotBeenSet);
        } else if (graph.isInstanceOf(node, l0.Literal) || graph.isInstanceOf(node, l0.SCLValue)) {
            Statement propertyOwner = graph.getPossibleStatement(node, l0.PropertyOf);
            Resource propertyRelation = null;
            boolean defaultValue = false;
            if (propertyOwner != null) {
                propertyRelation = graph.getInverse(propertyOwner.getPredicate());
            } else {
                Resource objectInverse = graph.getPossibleObject(node, l0.HasObjectInverse);
                if (objectInverse != null) {
                    propertyRelation = graph.getPossibleObject(objectInverse, l0.HasPredicate);
                    defaultValue = true;
                }
            }
            if (propertyRelation != null) {
                String propName = (String)graph.getPossibleRelatedValue2(propertyRelation, l0.HasLabel);
                if (propName == null || propName.length() == 0) {
                    propName = (String)graph.getRelatedValue(propertyRelation, l0.HasName);
                }
                labels[0] = propName;
            } else {
                labels[0] = "";
            }
            if (graph.hasValue(node)) {
                Object value = graph.getValue(node);
                labels[1] = SourceLinkUtil.getValueString(value);
            } else {
                labels[1] = !graph.isInstanceOf(node, l0.SCLValue) ? Messages.VariableLabelRule_NoValue : "";
            }
            if (defaultValue) {
                NLS.bind((String)Messages.VariableLabelRule_LabelDefault, (Object)labels[1]);
            }
            labels[2] = "";
            labels[3] = "";
        } else {
            labels[0] = NameUtils.getSafeLabel((ReadGraph)graph, (Resource)node);
            if (labels[0].length() == 0) {
                labels[0] = NameUtils.getSafeName((ReadGraph)graph, (Resource)node);
            }
            labels[1] = "";
            labels[2] = "";
            labels[3] = "";
        }
        return ArrayMap.make((Object[])keys, (Object[])labels);
    }
}

