/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.StandardGraphPropertyVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.linking.ge.Constants;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.silk.SilkResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;

public class VariableImageRule
implements ImageRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class);
    }

    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        Variable v = (Variable)content;
        Resource r = v.getPossibleRepresents(graph);
        if (r == null) {
            return null;
        }
        DocumentLink sl = DocumentLink.getInstance((ReadGraph)graph);
        SilkResources SILK = SilkResources.getInstance((ReadGraph)graph);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        SimulationResource sim = SimulationResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(r, sl.Source)) {
            return Collections.singletonMap(Constants.REFERENCE, (ImageDescriptor)graph.adapt(SILK.page_white, ImageDescriptor.class));
        }
        if (graph.isInstanceOf(r, sr.Composite)) {
            return Collections.singletonMap(Constants.NAME, (ImageDescriptor)graph.adapt(SILK.application, ImageDescriptor.class));
        }
        if (graph.isInstanceOf(r, sr.Component)) {
            return Collections.singletonMap(Constants.NAME, (ImageDescriptor)graph.adapt(SILK.brick, ImageDescriptor.class));
        }
        if (graph.isInstanceOf(r, sim.Model)) {
            return Collections.singletonMap(Constants.NAME, (ImageDescriptor)graph.adapt(SILK.chart_organisation, ImageDescriptor.class));
        }
        if (content instanceof StandardGraphPropertyVariable) {
            return Collections.singletonMap(Constants.NAME, (ImageDescriptor)graph.adapt(SILK.cog, ImageDescriptor.class));
        }
        return null;
    }
}

