/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class MultiSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener {
    private List<ISelectionProvider> selectionProviders = new ArrayList<ISelectionProvider>();
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private ISelection selection;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        SelectionChangedEvent fireEvent = new SelectionChangedEvent((ISelectionProvider)this, this.selection);
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(fireEvent);
        }
    }

    public void addSelectionProvider(ISelectionProvider provider) {
        this.selectionProviders.add(provider);
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void removeSelectionProvider(ISelectionProvider provider) {
        this.selectionProviders.remove(provider);
        provider.removeSelectionChangedListener((ISelectionChangedListener)this);
    }
}

