package org.simantics.document.linking.report.templates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.document.DocumentResource;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.Document;
import org.simantics.document.linking.report.DocumentTitlePage;
import org.simantics.document.linking.report.RowContentProvider;
import org.simantics.document.linking.report.Table;
import org.simantics.document.linking.report.TextItem;
import org.simantics.document.linking.utils.SourceLinkUtil;
import org.simantics.modeling.ModelingResources;

public class DiagramStructureWriter extends DocumentWriter<Resource>{
	ReadGraph graph;
	Resource model;
	Map<Object, Object> context;
	DocumentLink sl;
	ModelingResources mod;
	DocumentResource doc;
	NestedComparator<Resource> diagramDocumentComparator;
	ResourceNameComparator diagramComparator;
	
	@Override
	public String getName() {
		return "Diagram structure"; //$NON-NLS-1$
	}
	
	@Override
	public void start(ReadGraph graph, Resource model, Document lineWriter, Map<Object, Object> context)
			throws Exception {
		super.start(graph, model, lineWriter, context);
		this.context = context;
		DocumentTitlePage titlePage = lineWriter.newElement(DocumentTitlePage.class);
		titlePage.writeTitle(graph, context);
		
		Table table = lineWriter.newElement(Table.class);
		table.addColumn("Name", 0.4); //$NON-NLS-1$
		table.addColumn("Document", 0.6); //$NON-NLS-1$
		
		//lineWriter.nextPage();
		
		this.graph = graph;
		this.sl = DocumentLink.getInstance(graph);
		this.mod = ModelingResources.getInstance(graph);
		this.doc = DocumentResource.getInstance(graph);
		this.model = model;
		
		diagramComparator = new SourceParentDiagramComparator(graph,model);
		diagramDocumentComparator = new NestedComparator<Resource>();
		diagramDocumentComparator.addComparator(diagramComparator);
		diagramDocumentComparator.addComparator(new SourceReferenceComparator(graph, model));
		
		clearProviders();
		addCellProvider(new HierarchyContentProvider());
		addCellProvider(new DocumentContentProvider());
	}
	
	
	@Override
	public List<Resource> getReportItems(ReadGraph graph)	throws Exception {
		Instances instancesQuery = graph.adapt(sl.Source, Instances.class);
        Collection<Resource> found = instancesQuery.find(graph, model);
        List<Resource> list = new ArrayList<Resource>();
        for (Resource source : found) {
        	Resource parent = graph.getSingleObject(source, sl.hasSource_Inverse);
        	if (graph.hasStatement(parent, mod.CompositeToDiagram))
        		list.add(source);
        }
        Collections.sort(list, diagramDocumentComparator);
        return list;
        
	}

	private class HierarchyContentProvider implements RowContentProvider<Resource> {
		@Override
		public void setText(Document writer, Resource previous,
				Resource current, Resource next, TextItem[] row) throws Exception {
			boolean writeHierarchy = false;
			if (previous == null)
				writeHierarchy = true;
			else  {
				if (diagramComparator.compare(previous, current) != 0)
					writeHierarchy = true;
			}
			if (writeHierarchy) {
//				if (lineWriter.getCurrentLine() > 4)
//					lineWriter.nextPage();
				Resource obj = graph.getPossibleObject(current, sl.hasSource_Inverse);
				row[0] = writer.newItem(TextItem.class);
				if (obj != null) {
					List<Resource> path = SourceLinkUtil.getDiagramPath(graph, model, obj);
					if (writer.getAvailableLines() < 2)
						writer.nextPage();
					String text = ""; //$NON-NLS-1$
					for (int i = 0 ; i < path.size(); i++) {
						Resource r = path.get(i);
						text += diagramComparator.getText(r);
						if (i < path.size()-1)
							text += "/"; //$NON-NLS-1$
					}
					row[0].setText(text);
				} else {
					row[0].setText(Messages.DiagramStructureWriter_Hierarchymissing);
				}
			}
			
		}
	}
	
	private class DocumentContentProvider implements RowContentProvider<Resource> {
		@Override
		public void setText(Document writer, Resource previous,
				Resource current, Resource next, TextItem[] row) throws Exception {
			Resource document = SourceLinkUtil.getReferredDocument(graph, current);
			if (document != null) {
				row[1] = getDocumentItem(document);
			} else {
				row[1] = getNonExistingDocumentItem();
			}
			
		}
	}
	

}
