package org.simantics.document.linking.report.evaluator;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.document.linking.Activator;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.document.linking.report.TableColumn.Alignment;
import org.simantics.objmap.graph.annotations.OrderedSetType;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

@OrderedSetType(DocumentLink.URIs.EvaluatorTree_AligmentHint)
public class AlignmentHint extends HintNode implements EnumEditableNode{
	
	
	Alignment alignment;
	
	public AlignmentHint() {
		alignment = Alignment.LEFT;
	}
	
	public AlignmentHint(Alignment alignment) {
		this.alignment = alignment;
	}
	
	@Override
	public String toString() {
		return alignment.toString();
	}
	
	@RelatedGetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public String getValue() {
		return alignment.toString();
	}
	
	public AlignmentHint setAlignment(Alignment alignment) {
		this.alignment = alignment;
		return this;
	}
	
	@RelatedSetValue(DocumentLink.URIs.EvaluatorTree_HasValue)
	@Override
	public void setValue(String value) {
		alignment = Alignment.valueOf(value);
	}
	
	@Override
	public String[] getEnumearation() {
		String values[] = new String[Alignment.values().length];
		for (int i = 0; i < values.length; i++)
			values[i] = Alignment.values()[i].toString();
		return values;
	}
	
	@Override
	public Object getHintValue() {
		return alignment;
	}
	
	@Override
	public Object getHintClass() {
		return Alignment.class;
	}
	
	@Override
	public EvaluatorItem copy() {
		AlignmentHint a = new AlignmentHint(alignment);
		copyChildren(a);
		return a;
	}
	
	@Override
	public ImageDescriptor getImage() {
		if (alignment == Alignment.LEFT) {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_align_left.png"); //$NON-NLS-1$ //$NON-NLS-2$
		} else if (alignment == Alignment.CENTER) {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_align_center.png"); //$NON-NLS-1$ //$NON-NLS-2$
		} else {
			return Activator.imageDescriptorFromPlugin("com.famfamfam.silk", "icons/text_align_right.png"); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}
	
	
}
