package org.simantics.document.linking.ge;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

/**
 * Selection Provider for providing slections from multiple GraphExplorers attached to the same site
 * .
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class MultiSelectionProvider implements ISelectionProvider, ISelectionChangedListener {
	
	private List<ISelectionProvider> selectionProviders = new ArrayList<ISelectionProvider>();
	private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
	private ISelection selection;
	
	@Override
	public void addSelectionChangedListener(ISelectionChangedListener listener) {
		listeners.add(listener);
		
	}
	@Override
	public void removeSelectionChangedListener(
			ISelectionChangedListener listener) {
		listeners.remove(listener);
		
	}
	
	@Override
	public ISelection getSelection() {
		return selection;
	}
	
	@Override
	public void setSelection(ISelection selection) {
		this.selection = selection;
		// TODO : should we pass the selection to selectionProviders? 
	}
	
	@Override
	public void selectionChanged(SelectionChangedEvent event) {
		this.selection = event.getSelection();
		SelectionChangedEvent fireEvent = new SelectionChangedEvent(this, selection);
		for (ISelectionChangedListener l : listeners) {
			l.selectionChanged(fireEvent);
		}
		
	}
	
	public void addSelectionProvider(ISelectionProvider provider) {
		selectionProviders.add(provider);
		provider.addSelectionChangedListener(this);
	}
	
	public void removeSelectionProvider(ISelectionProvider provider) {
		selectionProviders.remove(provider);
		provider.removeSelectionChangedListener(this);
	}

}
