package org.simantics.document.linking.actions;

import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.genericrelation.Dependencies;
import org.simantics.db.request.Read;
import org.simantics.document.linking.ontology.DocumentLink;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.workbench.search.ISearchService;
import org.simantics.workbench.search.SearchQuery;

public class SearchLinksAction implements ActionFactory {
	
	
	
	@Override
	public Runnable create(Object target) {
		if(!(target instanceof Resource))
			return null;
		final Resource resource = (Resource)target;
		return new Runnable() {
			
			@Override
			public void run() {
				try {
					String name = Simantics.getSession().syncRequest(new Read<String>() {
						@Override
						public String perform(ReadGraph graph)
								throws DatabaseException {
							Layer0 l0 = Layer0.getInstance(graph);
							String s = graph.getPossibleRelatedValue(resource, l0.HasLabel, Bindings.STRING);
							if (s == null)
								s = graph.getRelatedValue(resource, l0.HasName, Bindings.STRING);
							return s;
						}
					});
					ISearchService searchService = (ISearchService) PlatformUI.getWorkbench().getService(ISearchService.class);
					SearchQuery query = new SearchQuery(name);
					query.setSearchFlag(Dependencies.FIELD_NAME_SEARCH, "on"); //$NON-NLS-1$
					query.setSearchFlag(DocumentLink.URIs.SearchFunction, "on"); //$NON-NLS-1$
					searchService.performQuery(query, ISearchService.ResultBrowser.VIEW, true);
				} catch (DatabaseException e) {
					ExceptionUtils.logAndShowError(Messages.SearchLinksAction_CannotPerformSearch, e);
				}

			}
		};
	}

}
