/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.elements.AdaptableImmutableProxyElement;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.diagram.participant.ElementJSON;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkbenchSelectionProvider
extends AbstractCanvasParticipant
implements IPostSelectionProvider,
ElementJSON {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkbenchSelectionProvider.class);
    private static final long POST_SELECTION_DELAY = 300L;
    @DependencyReflection.Dependency
    protected Selection selection;
    protected IThreadWorkQueue swt;
    protected IWorkbenchPartSite site;
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    protected CopyOnWriteArrayList<ISelectionChangedListener> listeners = new CopyOnWriteArrayList();
    protected CopyOnWriteArrayList<ISelectionChangedListener> postListeners = new CopyOnWriteArrayList();
    private int modCount = 0;

    public WorkbenchSelectionProvider(IThreadWorkQueue swt) {
        this(swt, null);
    }

    public WorkbenchSelectionProvider(IThreadWorkQueue swt, IWorkbenchPartSite site) {
        this.swt = swt;
        this.site = site;
        if (site != null) {
            site.setSelectionProvider((ISelectionProvider)this);
        }
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.swt.asyncExec(() -> {
            if (this.site != null && this.site.getSelectionProvider() != this) {
                this.site.setSelectionProvider((ISelectionProvider)this);
            }
        });
    }

    public void removedFromContext(ICanvasContext ctx) {
        this.swt.asyncExec(() -> {
            if (this.site != null && this.site.getSelectionProvider() == this) {
                this.site.setSelectionProvider(null);
            }
        });
        super.removedFromContext(ctx);
    }

    public void fireSelection(Iterable<?> selection) {
        ISelection s = this.constructAdaptableSelection(selection);
        this.swt.asyncExec(() -> {
            this.currentSelection = s;
            this.fireSelectionChanged(s);
            this.schedulePostSelectionChanged(s);
        });
    }

    @HintReflection.HintListener(Class=Selection.class, Field="SELECTION0")
    public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        Iterable selection = (Iterable)newValue;
        this.fireSelection(selection);
    }

    @HintReflection.HintListener(Class=Selection.class, Field="SELECTION0")
    public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
        this.fireSelection(Collections.emptyList());
    }

    protected void schedulePostSelectionChanged(ISelection s) {
        int count = ++this.modCount;
        ThreadUtils.getNonBlockingWorkExecutor().schedule(() -> {
            int newCount = this.modCount;
            if (count != newCount) {
                return;
            }
            if (this.isRemoved()) {
                return;
            }
            this.swt.asyncExec(() -> {
                if (!this.isRemoved()) {
                    this.firePostSelectionChanged(s);
                }
            });
        }, 300L, TimeUnit.MILLISECONDS);
    }

    protected ISelection constructAdaptableSelection(Iterable<?> selection) {
        ArrayList<AdaptableImmutableProxyElement> objects = new ArrayList<AdaptableImmutableProxyElement>();
        for (Object o : selection) {
            if (o instanceof IElement) {
                IElement e = (IElement)o;
                Object object = e.getHint(ElementHints.KEY_OBJECT);
                if (object != null) {
                    objects.add(new AdaptableImmutableProxyElement(e));
                    continue;
                }
                System.out.println("  discarding element from selection, null object for " + e);
                continue;
            }
            System.out.println("  unrecognized selection: " + o.getClass() + ": " + o);
        }
        return new StructuredSelection(objects);
    }

    void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(e);
        }
    }

    void firePostSelectionChanged(ISelection selection) {
        SelectionChangedEvent e = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.postListeners) {
            l.selectionChanged(e);
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.add(listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.postListeners.remove(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection selection) {
        System.out.println("WorkbenchSelectionProvider: TODO: set selection: " + selection);
    }

    public Optional<String> getJSON(IElement element) {
        ISelection sel = this.constructAdaptableSelection(Collections.singleton(element));
        try {
            return Optional.ofNullable(WorkbenchSelectionUtils.getPossibleJSON((Object)sel));
        }
        catch (DatabaseException e) {
            LOGGER.error("Unexpected failure while constructing JSON from element " + element, (Throwable)e);
            return Optional.empty();
        }
    }
}

