/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph.layer;

import java.util.HashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.layer.GraphLayer;
import org.simantics.diagram.synchronization.graph.layer.IGraphLayerUtil;
import org.simantics.layer0.Layer0;

public final class GraphLayerUtil
implements IGraphLayerUtil {
    @Override
    public GraphLayer createLayer(WriteGraph graph, String layerName, boolean active) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Resource layer = graph.newResource();
        graph.claim(layer, L0.InstanceOf, null, DIA.Layer);
        Resource visibleTag = GraphLayerUtil.newTag(graph, L0, DIA.IsVisible);
        Resource focusableTag = GraphLayerUtil.newTag(graph, L0, DIA.IsFocusable);
        graph.claim(layer, DIA.HasVisibleTag, visibleTag);
        graph.claim(layer, DIA.HasFocusableTag, focusableTag);
        Resource name = graph.newResource();
        graph.claim(name, L0.InstanceOf, null, L0.String);
        graph.claimValue(name, (Object)layerName);
        graph.claim(layer, L0.HasName, name);
        graph.claim(visibleTag, L0.HasName, name);
        graph.claim(focusableTag, L0.HasName, name);
        GraphLayerUtil.setLayerActive(graph, DIA, layer, active);
        HashMap<String, Resource> properties = new HashMap<String, Resource>();
        properties.put("PROP_FOCUSABLE", focusableTag);
        properties.put("PROP_VISIBLE", visibleTag);
        return new GraphLayer(layerName, layer, properties);
    }

    public static Resource newTag(WriteGraph graph, Layer0 L0, Resource baseTag) throws DatabaseException {
        Resource tag = graph.newResource();
        graph.claim(tag, L0.SubrelationOf, baseTag);
        graph.claim(tag, L0.InverseOf, tag);
        return tag;
    }

    public static void setLayerActive(WriteGraph graph, DiagramResource DIA, Resource layer, boolean active) throws ManyObjectsForFunctionalRelationException, ServiceException {
        graph.claimLiteral(layer, DIA.IsActive, (Object)active);
    }

    @Override
    public GraphLayer loadLayer(ReadGraph graph, Resource layer) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        String name = (String)graph.getRelatedValue(layer, L0.HasName);
        Resource visible = graph.getSingleObject(layer, DIA.HasVisibleTag);
        Resource focusable = graph.getSingleObject(layer, DIA.HasFocusableTag);
        HashMap<String, Resource> properties = new HashMap<String, Resource>();
        properties.put("PROP_FOCUSABLE", focusable);
        properties.put("PROP_VISIBLE", visible);
        return new GraphLayer(name, layer, properties);
    }
}

