/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.profile;

import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.simantics.common.color.Color;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.elements.ITextListener;
import org.simantics.diagram.elements.TextGridNode;
import org.simantics.diagram.profile.MonitorTextGridResult;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.utils.Alignment;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.ConnectionNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.ui.colors.Colors;
import org.simantics.utils.datastructures.Pair;

public abstract class TextGridStyle
extends StyleBase<MonitorTextGridResult> {
    private final Font FONT = Font.decode("Arial 12");
    private final java.awt.Color BACKGROUND_COLOR = new java.awt.Color(255, 255, 255, 192);
    private static final Rectangle2D EMPTY_BOUNDS = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    protected double xOffset;
    protected double yOffset;
    protected static final Point2D[] DEFAULT_CELL_OFFSETS = new Point2D[]{new Point2D.Double(-45.0, 0.0), new Point2D.Double(22.0, 0.0), new Point2D.Double(24.0, 0.0)};
    protected static final Point2D[] ZERO_CELL_OFFSETS = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
    private static final Comparator<Pair<TextGridStyle, MonitorTextGridResult>> ROW_PRIORITY_COMPARATOR = (o1, o2) -> Double.compare(((TextGridStyle)o1.first).getPriority(), ((TextGridStyle)o2.first).getPriority());

    public TextGridStyle(Resource r) {
        this(r, 0.0, 2.1);
    }

    public TextGridStyle(Resource r, double xOffset, double yOffset) {
        super(r);
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    public Resource getPropertyRelation(ReadGraph g, Resource module) {
        throw new Error("Fix this");
    }

    public String getNodeName() {
        return this.getClass().getSimpleName();
    }

    protected Resource getConfigurationComponent(ReadGraph graph, Resource element) throws DatabaseException {
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        Resource config = graph.getPossibleObject(element, mr.ElementToComponent);
        return config;
    }

    protected String getConfigurationComponentNameForElement(ReadGraph graph, Resource element) throws DatabaseException {
        Resource config = this.getConfigurationComponent(graph, element);
        if (config == null) {
            return null;
        }
        String name = (String)graph.getPossibleRelatedValue(config, this.getPropertyRelation(graph, element), (Binding)Bindings.STRING);
        return name;
    }

    public AffineTransform getTransform(INode node, AffineTransform parentTransform, Rectangle2D elementBounds, int location, boolean up) {
        return this.getTransform(parentTransform, elementBounds, location, up);
    }

    public AffineTransform getTransform(AffineTransform parentTransform, Rectangle2D elementBounds, int location, boolean up) {
        double scale = GeometryUtils.getScale((AffineTransform)parentTransform);
        AffineTransform at = AffineTransform.getTranslateInstance(parentTransform.getTranslateX() + elementBounds.getCenterX() * scale + this.xOffset, parentTransform.getTranslateY() + elementBounds.getMinY() * scale + this.yOffset * (double)(location - 1) + (up ? 0.0 : 2.0 * this.yOffset + elementBounds.getHeight() * scale));
        at.scale(0.15, 0.15);
        return at;
    }

    protected String rowId() {
        return "";
    }

    @Override
    public MonitorTextGridResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        String name = this.getConfigurationComponentNameForElement(graph, element);
        if (name == null) {
            return null;
        }
        AffineTransform transform = DiagramGraphUtil.getDynamicAffineTransform(graph, runtimeDiagram, element);
        Vec2d offset = DiagramGraphUtil.getOffset(graph, element);
        boolean enabled = !DiagramGraphUtil.getProfileMonitorsHidden(graph, element);
        boolean up = DiagramGraphUtil.getProfileMonitorsUp(graph, element);
        double spacing = DiagramGraphUtil.getProfileMonitorSpacing(graph, element);
        return new MonitorTextGridResult(this.rowId(), name, "", "", enabled, up, spacing, null, null, null, transform, offset);
    }

    protected Point2D[] getCellOffsets() {
        return DEFAULT_CELL_OFFSETS;
    }

    @Override
    public void applyStyleForNode(EvaluationContext observer, INode _node, MonitorTextGridResult result) {
        boolean enabled;
        String value = result != null ? result.getText1() : null;
        boolean bl = enabled = result != null ? result.getEnabled() : false;
        if (value != null && enabled) {
            Pair oldResultPair;
            HashMap<String, Pair> rows = (HashMap<String, Pair>)observer.getProperty(_node, "rows");
            if (rows == null) {
                rows = new HashMap<String, Pair>();
                observer.setProperty(_node, "rows", rows);
            }
            if ((oldResultPair = (Pair)rows.get(result.getRowId())) != null && oldResultPair.first == this && ((MonitorTextGridResult)((Object)oldResultPair.second)).sameStructure(result)) {
                return;
            }
            rows.put(this.rowIdKey(), new Pair((Object)this, (Object)result));
            TextGridStyle.refreshAll(observer, _node);
        } else {
            this.cleanupStyleForNode(observer, _node);
        }
    }

    private static void refreshAll(EvaluationContext observer, INode _node) {
        final TextGridNode node = (TextGridNode)ProfileVariables.claimChild((INode)_node, (String)"", (String)"TextGridStyle", TextGridNode.class, (Observer)observer);
        if (node == null) {
            return;
        }
        int row = 0;
        Map rows = (Map)observer.getProperty(_node, "rows");
        if (rows != null) {
            List sortedRows = rows.values().stream().sorted(ROW_PRIORITY_COMPARATOR).collect(Collectors.toList());
            for (Pair resultPair : sortedRows) {
                Rectangle2D elementBounds;
                ++row;
                TextGridStyle style = (TextGridStyle)resultPair.first;
                MonitorTextGridResult result = (MonitorTextGridResult)((Object)resultPair.second);
                String value = result != null ? result.getText1() : null;
                String value2 = result != null ? result.getText2() : null;
                String value3 = result != null ? result.getText3() : null;
                double spacing = result.getSpacing();
                final Function1<String, String> modifier = result != null ? result.getModifier() : null;
                Function1<String, String> validator = result != null ? result.getValidator() : null;
                Function1<Vec2d, Boolean> translator = result != null ? result.getTranslator() : null;
                RVI rvi = result != null ? result.getRVI() : null;
                node.setRowId(row, result.getRowId());
                node.setText(2, row, value2);
                node.setUp(result.getUp());
                node.setCache(1, row, result);
                boolean isConnection = _node instanceof ConnectionNode;
                Rectangle2D rectangle2D = elementBounds = isConnection ? EMPTY_BOUNDS : NodeUtil.getLocalElementBounds((INode)_node);
                if (elementBounds == null) {
                    new Exception("Cannot get local element bounds for node " + _node.toString()).printStackTrace();
                    NodeUtil.getLocalElementBounds((INode)_node);
                    return;
                }
                AffineTransform at = style.getTransform(_node, result.getParentTransform(), elementBounds, row, result.getUp());
                Vec2d offset = result.getOffset();
                Point2D[] cellOffsets = style.getCellOffsets();
                AffineTransform at1 = new AffineTransform(at);
                at1.translate(cellOffsets[0].getX(), cellOffsets[0].getY());
                AffineTransform at2 = new AffineTransform(at);
                at2.translate(cellOffsets[1].getX() + spacing, cellOffsets[1].getY());
                AffineTransform at3 = new AffineTransform(at);
                at3.translate(cellOffsets[2].getX() + spacing, cellOffsets[2].getY());
                at1.translate(offset.x, offset.y);
                at2.translate(offset.x, offset.y);
                at3.translate(offset.x, offset.y);
                node.setTransform(1, row, at1);
                node.setTransform(2, row, at2);
                node.setTransform(3, row, at3);
                Alignment[] alignments = result.getAlignments();
                if (alignments != null) {
                    node.setHorizontalAlignment(1, row, (byte)alignments[0].ordinal());
                    node.setHorizontalAlignment(2, row, (byte)alignments[1].ordinal());
                    node.setHorizontalAlignment(3, row, (byte)alignments[2].ordinal());
                } else {
                    node.setHorizontalAlignment(1, row, (byte)style.getAlignment(1).ordinal());
                    node.setHorizontalAlignment(2, row, (byte)style.getAlignment(2).ordinal());
                    node.setHorizontalAlignment(3, row, (byte)style.getAlignment(3).ordinal());
                }
                Alignment[] verticalAlignments = result.getVerticalAlignments();
                if (verticalAlignments != null) {
                    node.setVerticalAlignment(1, row, (byte)verticalAlignments[0].ordinal());
                    node.setVerticalAlignment(2, row, (byte)verticalAlignments[1].ordinal());
                    node.setVerticalAlignment(3, row, (byte)verticalAlignments[2].ordinal());
                } else {
                    node.setVerticalAlignment(1, row, (byte)style.getVerticalAlignment(1).ordinal());
                    node.setVerticalAlignment(2, row, (byte)style.getVerticalAlignment(2).ordinal());
                    node.setVerticalAlignment(3, row, (byte)style.getVerticalAlignment(3).ordinal());
                }
                node.setZIndex(3000);
                Color color = result.getColor();
                java.awt.Color awtColor = color != null ? Colors.awt((Color)color) : java.awt.Color.DARK_GRAY;
                java.awt.Color bgColor = style.getBackgroundColor();
                Font font = style.getFont();
                style.setTextNodeData(node, 1, row, value, font, awtColor, bgColor);
                style.setTextNodeData(node, 2, row, value2, result.getPending(), font, awtColor, bgColor);
                style.setTextNodeData(node, 3, row, value3, font, awtColor, bgColor);
                node.setEditable(1, row, false);
                node.setForceEventListening(2, row, true);
                node.setEditable(2, row, modifier != null);
                node.setEditable(3, row, false);
                final int finalRow = row;
                if (modifier != null) {
                    node.setTextListener(2, row, new ITextListener(){

                        @Override
                        public void textChanged() {
                        }

                        @Override
                        public void textEditingStarted() {
                        }

                        @Override
                        public void textEditingCancelled() {
                        }

                        @Override
                        public void textEditingEnded() {
                            TextGridNode.A t = node.get(2, finalRow);
                            if (t == null) {
                                return;
                            }
                            if (!t.getText().equals(t.getTextBeforeEdit())) {
                                modifier.apply((Object)t.getText());
                            }
                        }
                    });
                } else {
                    node.setTextListener(2, row, null);
                }
                node.setInputValidator(2, row, validator);
                node.setTranslator(translator);
                node.setRVI(2, row, rvi);
                style.postProcessNode(node, row);
            }
        }
        int rowCount = node.computeRows();
        while (row < rowCount) {
            node.removeRow(++row);
        }
    }

    private void setTextNodeData(TextGridNode node, int x, int y, String text, Font font, java.awt.Color fgColor, java.awt.Color bgColor) {
        if (text != null) {
            node.setText(x, y, text);
            node.setFont(x, y, font);
            node.setColor(x, y, fgColor);
            node.setBackgroundColor(x, y, bgColor);
        } else {
            node.setFont(x, y, null);
        }
    }

    private void setTextNodeData(TextGridNode node, int x, int y, String text, boolean pending, Font font, java.awt.Color fgColor, java.awt.Color bgColor) {
        this.setTextNodeData(node, x, y, text, font, fgColor, bgColor);
        node.setPending(x, y, pending);
    }

    protected Font getFont() {
        return this.FONT;
    }

    protected java.awt.Color getBackgroundColor() {
        return this.BACKGROUND_COLOR;
    }

    protected Alignment getAlignment(int column) {
        switch (column) {
            case 1: {
                return Alignment.TRAILING;
            }
            case 2: {
                return Alignment.TRAILING;
            }
            case 3: {
                return Alignment.LEADING;
            }
        }
        return Alignment.LEADING;
    }

    protected Alignment getVerticalAlignment(int column) {
        return Alignment.TRAILING;
    }

    @Override
    protected void cleanupStyleForNode(EvaluationContext observer, INode _node) {
        Map rows = (Map)observer.getProperty(_node, "rows");
        if (rows != null) {
            rows.remove(this.rowIdKey());
            if (rows.isEmpty()) {
                observer.setProperty(_node, "rows", null);
            }
        }
        TextGridStyle.refreshAll(observer, _node);
    }

    protected void postProcessNode(TextGridNode node, int row) {
    }

    private String rowIdKey() {
        return "style" + this.getIdentity().toString();
    }
}

