/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.Simantics;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.elements.ElementTransforms;
import org.simantics.diagram.flag.IOTableUtil;
import org.simantics.diagram.flag.IOTablesInfo;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.diagram.participant.pointertool.TranslateMode;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Move;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.Decoration;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.utils.ui.ErrorLogger;

public class TranslateMode2
extends TranslateMode {
    IOTablesInfo ioTablesInfo = null;

    public TranslateMode2(Point2D startingPoint, Point2D currentPoint, int mouseId, Collection<IElement> elements) {
        super(startingPoint, currentPoint, mouseId, elements);
    }

    protected boolean commit() {
        for (IElement el : this.elementsToReallyTranslate) {
            Move move = (Move)el.getElementClass().getAtMostOneItemOfClass(Move.class);
            if (move == null) continue;
            Point2D oldPos = move.getPosition(el);
            move.moveTo(el, oldPos.getX() + this.dx, oldPos.getY() + this.dy);
        }
        try {
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                    ArrayList<ElementTransforms.TransformedObject> transformed = new ArrayList<ElementTransforms.TransformedObject>();
                    for (IElement e : TranslateMode2.this.elementsToReallyTranslate) {
                        Resource r;
                        Object obj = ElementUtils.getObject((IElement)e);
                        if (!(obj instanceof Resource) || graph.isInstanceOf(r = (Resource)obj, DIA.RouteGraphConnection) || graph.isInstanceOf(r, DIA.Flag) && TranslateMode2.this.handleFlag(graph, DIA, e, r)) continue;
                        AffineTransform at = ElementUtils.getLocalTransform((IElement)e, (AffineTransform)new AffineTransform());
                        transformed.add(new ElementTransforms.TransformedObject((Resource)obj, at));
                    }
                    if (!transformed.isEmpty()) {
                        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                        graph.addMetadata((Metadata)cm.add("Translated " + transformed.size() + " " + (transformed.size() == 1 ? "element" : "elements") + " by (" + TranslateMode2.this.dx + "," + TranslateMode2.this.dy + ") mm."));
                        graph.markUndoPoint();
                    }
                    ElementTransforms.setTransformRequest(transformed).perform(graph);
                    ConnectionUtil cu = new ConnectionUtil(graph);
                    for (IElement c : TranslateMode2.this.translatedConnections) {
                        Resource connection;
                        Object obj = ElementUtils.getObject((IElement)c);
                        if (!(obj instanceof Resource) || !graph.isInstanceOf(connection = (Resource)obj, DIA.RouteGraphConnection)) continue;
                        cu.translateRouteNodes(connection, TranslateMode2.this.dx, TranslateMode2.this.dy);
                    }
                }
            });
        }
        catch (DatabaseException err) {
            ErrorLogger.defaultLogError((Throwable)err);
        }
        for (IElement dirty : this.elementsToDirty) {
            dirty.setHint(Hints.KEY_DIRTY, (Object)Hints.VALUE_SG_DIRTY);
        }
        this.setDirty();
        this.remove();
        return false;
    }

    private boolean handleFlag(WriteGraph graph, DiagramResource DIA, IElement flagElement, Resource flagResource) throws DatabaseException {
        Object sgNode;
        if (this.ioTablesInfo == null) {
            this.ioTablesInfo = IOTableUtil.getIOTablesInfo((ReadGraph)graph, (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE));
        }
        if (!((sgNode = flagElement.getHint(ElementHints.KEY_SG_NODE)) instanceof IG2DNode)) {
            return false;
        }
        Rectangle2D flagBounds = NodeUtil.getLocalBounds((INode)((IG2DNode)sgNode), Decoration.class);
        Point2D translateVector = this.getTranslateVector();
        double flagX = flagBounds.getCenterX() + translateVector.getX();
        double flagY = flagBounds.getCenterY() + translateVector.getY();
        return this.ioTablesInfo.updateBinding(graph, DIA, flagResource, flagX, flagY);
    }
}

