/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.diagram.elements.ElementTransforms;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.Scale;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.element.impl.MutatedElement;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.utils.datastructures.hints.IHintContext;

public class MouseScaleMode
extends AbstractMode {
    private static final IHintContext.Key KEY_SCALE_NODE = new SceneGraphNodeKey(INode.class, "SCALE_NODE");
    private static final boolean DEBUG = false;
    @DependencyReflection.Dependency
    ElementPainter painter;
    Set<IElement> selection;
    Map<IElement, Point2D> originalScales = new HashMap<IElement, Point2D>();
    Map<IElement, MutatedElement> scaledElements = new HashMap<IElement, MutatedElement>();
    Point2D initialMousePos;
    Point2D pivotPosition;
    AffineTransform pivot;
    AffineTransform pivotInverse;
    Point2D lastMousePos = new Point2D.Double();
    Point2D newScale = new Point2D.Double();
    final ISnapAdvisor snapAdvisor;
    public static final ISnapAdvisor DEFAULT_SNAP = new ISnapAdvisor(){

        public void snap(Point2D point) {
            double resolution = 0.1;
            point.setLocation((double)Math.round(point.getX() / resolution) * resolution, (double)Math.round(point.getY() / resolution) * resolution);
        }

        public void snap(Point2D point, Point2D[] features) {
            this.snap(point);
        }
    };
    protected SingleElementNode node = null;

    public MouseScaleMode(int mouseId, MouseUtil.MouseInfo mi, Set<IElement> selection) {
        this(mouseId, mi, selection, DEFAULT_SNAP);
    }

    public MouseScaleMode(int mouseId, MouseUtil.MouseInfo mi, Set<IElement> selection, ISnapAdvisor snapAdvisor) {
        super(mouseId);
        this.snapAdvisor = snapAdvisor;
        this.selection = selection;
        this.selection = new HashSet<IElement>(selection);
        for (IElement e : selection) {
            if (e.getElementClass().containsClass(Scale.class)) continue;
            this.selection.remove(e);
        }
        if (this.selection.size() == 1) {
            AffineTransform at = ElementUtils.getTransform((IElement)this.selection.iterator().next());
            this.pivotPosition = new Point2D.Double(at.getTranslateX(), at.getTranslateY());
        } else {
            this.pivotPosition = this.selection.size() > 1 ? ElementUtils.getElementBoundsCenter(this.selection, null) : new Point2D.Double();
        }
        this.pivot = AffineTransform.getTranslateInstance(this.pivotPosition.getX(), this.pivotPosition.getY());
        this.pivotInverse = AffineTransform.getTranslateInstance(-this.pivotPosition.getX(), -this.pivotPosition.getY());
        this.initialMousePos = mi != null ? (Point2D)mi.canvasPosition.clone() : null;
        for (IElement e : this.selection) {
            Scale scale = (Scale)e.getElementClass().getAtMostOneItemOfClass(Scale.class);
            if (scale == null) continue;
            Point2D s = scale.getScale(e);
            System.out.println("");
            this.originalScales.put(e, s);
            this.scaledElements.put(e, new MutatedElement(e));
        }
    }

    @SGNodeReflection.SGInit
    public void initSG(G2DParentNode parent) {
        this.node = (SingleElementNode)parent.addNode("mouse scale ghost", SingleElementNode.class);
        this.node.setZIndex(2147482647);
        this.node.setComposite((Composite)AlphaComposite.SrcOver.derive(0.3f));
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
        this.node.remove();
        this.node = null;
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        if (this.selection.isEmpty()) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MouseScaleMode.this.isRemoved()) {
                        MouseScaleMode.this.remove();
                    }
                }
            });
        } else {
            this.update();
        }
    }

    public void removedFromContext(ICanvasContext ctx) {
        for (MutatedElement me : this.scaledElements.values()) {
            me.dispose();
        }
        super.removedFromContext(ctx);
    }

    public boolean handleCommand(CommandEvent ce) {
        if (Commands.CANCEL.equals((Object)ce.command)) {
            this.cancel();
            return true;
        }
        return true;
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleKeys(KeyEvent event) {
        if (event instanceof KeyEvent.KeyPressedEvent) {
            if (event.keyCode == 27) {
                this.cancel();
            } else if (event.keyCode == 10) {
                this.commit();
            }
        }
        return true;
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleMouse(MouseEvent event) {
        if (event instanceof MouseEvent.MouseButtonPressedEvent) {
            MouseEvent.MouseButtonPressedEvent mbpe = (MouseEvent.MouseButtonPressedEvent)event;
            if (mbpe.button == 1) {
                this.commit();
            }
        } else if (event instanceof MouseEvent.MouseMovedEvent) {
            double l;
            MouseEvent.MouseMovedEvent mme = (MouseEvent.MouseMovedEvent)event;
            ElementUtils.controlToCanvasCoordinate((ICanvasContext)this.getContext(), (Point2D)mme.controlPosition, (Point2D)this.lastMousePos);
            ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getContext().getDefaultHintContext().getHint(DiagramHints.SNAP_ADVISOR);
            double d = 0.0;
            if (this.initialMousePos != null) {
                double dx = this.initialMousePos.getX() - this.pivotPosition.getX();
                double dy = this.initialMousePos.getY() - this.pivotPosition.getY();
                d = Math.sqrt(dx * dx + dy * dy);
            }
            double lx = this.lastMousePos.getX() - this.pivotPosition.getX();
            double ly = this.lastMousePos.getY() - this.pivotPosition.getY();
            double s = l = Math.sqrt(lx * lx + ly * ly);
            if (d > 1.0E-9) {
                s /= d;
            } else if (d == 0.0) {
                s *= 0.01;
            } else {
                return true;
            }
            for (Map.Entry<IElement, Point2D> entry : this.originalScales.entrySet()) {
                IElement e = entry.getKey();
                Point2D originalScale = entry.getValue();
                ElementClass ec = e.getElementClass();
                IElement me = (IElement)this.scaledElements.get(e);
                this.newScale.setLocation(originalScale.getX() * s, originalScale.getY() * s);
                if (this.newScale.getX() < 2.0E-4 || this.newScale.getY() < 2.0E-4) continue;
                if (snapAdvisor != null) {
                    this.snapAdvisor.snap(this.newScale);
                }
                double sx = this.newScale.getX() / originalScale.getX();
                double sy = this.newScale.getY() / originalScale.getY();
                AffineTransform localAt = ElementUtils.getLocalTransform((IElement)e, (AffineTransform)new AffineTransform());
                Point2D localPos = ElementUtils.getPos((IElement)e, (Point2D)new Point2D.Double());
                Point2D worldPos = ElementUtils.getAbsolutePos((IElement)e, (Point2D)new Point2D.Double());
                Point2D.Double worldToLocal = new Point2D.Double(localPos.getX() - worldPos.getX(), localPos.getY() - worldPos.getY());
                if (sx == 0.0 || sy == 0.0) continue;
                localAt.scale(sx, sy);
                Point2D p = (Point2D)worldPos.clone();
                this.pivotInverse.transform(p, p);
                p.setLocation(p.getX() * sx, p.getY() * sy);
                this.pivot.transform(p, p);
                p.setLocation(p.getX() + ((Point2D)worldToLocal).getX(), p.getY() + ((Point2D)worldToLocal).getY());
                localAt.setTransform(localAt.getScaleX(), localAt.getShearY(), localAt.getShearX(), localAt.getScaleY(), p.getX(), p.getY());
                ((Transform)ec.getSingleItem(Transform.class)).setTransform(me, localAt);
            }
            this.update();
        }
        return true;
    }

    private void update() {
        for (IElement iElement : this.scaledElements.values()) {
            this.painter.updateElement((G2DParentNode)this.node, iElement, KEY_SCALE_NODE, false);
        }
        this.setDirty();
    }

    private void cancel() {
        this.setDirty();
        this.remove();
    }

    private void commit() {
        ArrayList<ElementTransforms.TransformedObject> transformed = new ArrayList<ElementTransforms.TransformedObject>();
        for (IElement iElement : this.scaledElements.values()) {
            Object obj = ElementUtils.getObject((IElement)iElement);
            if (!(obj instanceof Resource)) continue;
            AffineTransform at = ElementUtils.getLocalTransform((IElement)iElement, (AffineTransform)new AffineTransform());
            transformed.add(new ElementTransforms.TransformedObject((Resource)obj, at));
        }
        Simantics.getSession().asyncRequest(ElementTransforms.setTransformRequest(transformed));
        this.setDirty();
        this.remove();
    }
}

