/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.awt.Color;
import java.awt.Font;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.literal.RGB;
import org.simantics.diagram.adapter.FlagTextInfo;
import org.simantics.diagram.adapter.SVGImageInfo;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.diagram.elements.TextNode;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.ParentNode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.FlagNode;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.Fonts;
import org.simantics.utils.datastructures.hints.IHintContext;

public class FlagSceneGraph
implements SceneGraph {
    private static final long serialVersionUID = 35208146123929197L;
    public static final FlagSceneGraph INSTANCE = new FlagSceneGraph();
    public static final IHintContext.Key KEY_FLAG_VISUALS = new IHintContext.KeyOf(Bean[].class, "FLAG_MONITORS");
    public static final IHintContext.Key KEY_VISUAL_SG_NODE = new SceneGraphNodeKey(Node.class, "FLAG_VISUAL_NODE");
    private static final String VISUAL_ROOT = "visual";

    public void cleanup(IElement e) {
        ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)FlagClass.KEY_SG_NODE);
        ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)KEY_VISUAL_SG_NODE);
    }

    public void init(IElement e, G2DParentNode parent) {
        Bean[] flagVisuals = (Bean[])e.getHint(KEY_FLAG_VISUALS);
        if (flagVisuals == null || flagVisuals.length == 0) {
            Rectangle2D textArea;
            String text;
            Text t;
            Color fc = ElementUtils.getFillColor((IElement)e, (Color)Color.WHITE);
            Color bc = ElementUtils.getBorderColor((IElement)e, (Color)Color.BLACK);
            Color tc = ElementUtils.getTextColor((IElement)e, (Color)Color.BLACK);
            Outline outline = (Outline)e.getElementClass().getSingleItem(Outline.class);
            Shape shape = outline.getElementShape(e);
            FlagClass.Type type = FlagClass.getType((IElement)e);
            double dir = FlagClass.getDirection((IElement)e);
            double width = (Double)e.getHint(FlagClass.KEY_FLAG_WIDTH);
            double height = (Double)e.getHint(FlagClass.KEY_FLAG_HEIGHT);
            double beakAngle = (Double)e.getHint(FlagClass.KEY_FLAG_BEAK_ANGLE);
            String[] flagText = (String[])e.getHint(FlagClass.KEY_FLAG_TEXT);
            if (flagText == null && (t = (Text)e.getElementClass().getAtMostOneItemOfClass(Text.class)) != null && (text = t.getText(e)) != null) {
                flagText = new String[]{text};
            }
            if ((textArea = (Rectangle2D)e.getHint(FlagClass.KEY_FLAG_TEXT_AREA)) == null) {
                double beakLength = FlagClass.getBeakLength((double)height, (double)beakAngle);
                textArea = type == FlagClass.Type.In ? new Rectangle2D.Double(-width - beakLength, -height * 0.5, width, height) : new Rectangle2D.Double(0.0, -height * 0.5, width, height);
            }
            Alignment horizAlign = (Alignment)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)FlagClass.KEY_TEXT_HORIZONTAL_ALIGN, (Object)Alignment.LEADING);
            Alignment vertAlign = (Alignment)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)FlagClass.KEY_TEXT_VERTICAL_ALIGN, (Object)Alignment.CENTER);
            Font font = (Font)ElementUtils.getHintOrDefault((IHintContext)e, (IHintContext.Key)FlagClass.KEY_FLAG_FONT, (Object)FlagNode.DEFAULT_FONT);
            ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)KEY_VISUAL_SG_NODE);
            e.removeHint(KEY_VISUAL_SG_NODE);
            FlagNode flag = (FlagNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)FlagClass.KEY_SG_NODE, (String)ElementUtils.generateNodeId((IElement)e), FlagNode.class);
            flag.init(shape, flagText, (Stroke)FlagClass.STROKE, bc, fc, tc, (float)width, (float)height, (double)((float)dir), (float)beakAngle, textArea, horizAlign.ordinal(), vertAlign.ordinal(), font);
            AffineTransform at = ElementUtils.getTransform((IElement)e);
            if (at != null) {
                flag.setTransform(at);
            }
        } else {
            AffineTransform at;
            ElementUtils.removePossibleNode((IElement)e, (IHintContext.Key)FlagClass.KEY_SG_NODE);
            e.removeHint(FlagClass.KEY_SG_NODE);
            G2DParentNode par = (G2DParentNode)ElementUtils.getOrCreateNode((IElement)e, (ParentNode)parent, (IHintContext.Key)KEY_VISUAL_SG_NODE, (String)VISUAL_ROOT, G2DParentNode.class);
            if (par.getNodeCount() > 0) {
                par.removeNodes();
            }
            if ((at = ElementUtils.getTransform((IElement)e)) != null) {
                par.setTransform(at);
            }
            Bean[] beanArray = flagVisuals;
            int n = flagVisuals.length;
            int n2 = 0;
            while (n2 < n) {
                Bean info;
                Bean visual = beanArray[n2];
                if (visual instanceof FlagTextInfo) {
                    info = (FlagTextInfo)visual;
                    String text = info.text;
                    TextNode cellNode = (TextNode)((Object)par.getOrCreateNode(info.id, TextNode.class));
                    if (info.width >= 0.0f) {
                        cellNode.setFixedWidth(info.width);
                    }
                    cellNode.setWrapText(info.wrapText);
                    cellNode.setHorizontalAlignment((byte)info.hAlignment.ordinal());
                    cellNode.setVerticalAlignment((byte)info.vAlignment.ordinal());
                    if (info.borderWidth >= 0.0f) {
                        cellNode.setBorderWidth(info.borderWidth);
                    }
                    if (info.borderColor != null && info.borderWidth > 0.0f) {
                        cellNode.setBorderColor(Colors.awt((RGB.Integer)info.borderColor));
                    }
                    if (info.backgroundColor != null) {
                        cellNode.setBackgroundColor(Colors.awt((RGB.Integer)info.backgroundColor));
                    }
                    if (info.font != null) {
                        cellNode.setFont(Fonts.awt((org.simantics.datatypes.literal.Font)info.font));
                    }
                    if (info.color != null) {
                        cellNode.setColor(Colors.awt((RGB.Integer)info.color));
                    }
                    if (info.transform != null) {
                        cellNode.setTransform(new AffineTransform(info.transform));
                    }
                    if (text != null) {
                        cellNode.setText(text);
                    }
                } else if (visual instanceof SVGImageInfo) {
                    info = (SVGImageInfo)visual;
                    SVGNode svgNode = (SVGNode)((Object)par.getOrCreateNode(info.id, SVGNode.class));
                    if (info.svgDocument != null && !info.svgDocument.isEmpty()) {
                        svgNode.setData(info.svgDocument);
                    }
                    if (info.transform != null) {
                        svgNode.setTransform(new AffineTransform(info.transform));
                    }
                }
                ++n2;
            }
        }
    }
}

