/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.elements;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.simantics.diagram.elements.SVGNode;
import org.simantics.g2d.elementclass.AnimatedNode;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.utils.BufferedImage;
import org.simantics.scenegraph.utils.G2DUtils;
import org.simantics.scenegraph.utils.MipMapBufferedImage;
import org.simantics.scenegraph.utils.MipMapVRamBufferedImage;
import org.simantics.scenegraph.utils.VRamBufferedImage;

public class AnimatedSVGNode
extends SVGNode
implements AnimatedNode {
    private static final long serialVersionUID = 8698435757824280001L;
    public Map<String, Object> valuezz = new HashMap<String, Object>();
    protected String script = null;
    protected Map<String, String> eventAnimations = new HashMap<String, String>();

    @INode.PropertySetter(value="VariableFilter")
    @INode.SyncField(value={"script"})
    public void setScript(String script) {
        this.script = script;
    }

    @INode.SyncField(value={"values"})
    public void setValue(String key, Object value) {
        this.valuezz.put(key, value);
        this.animate();
    }

    @INode.PropertySetter(value="valuezz")
    @INode.SyncField(value={"valuezz"})
    public void setValuezz(Map<String, Object> val) {
        this.valuezz = val;
        this.animate();
    }

    @INode.ClientSide
    public void animate() {
        this.animate(this.script);
    }

    @INode.ClientSide
    public void animate(String script) {
        if (script == null) {
            return;
        }
        if (this.dataHash == null) {
            this.dataHash = this.parseSVG();
        }
        if (this.diagramCache == null) {
            return;
        }
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("JavaScript");
            for (String key : this.valuezz.keySet()) {
                engine.put(key, this.valuezz.get(key));
            }
            engine.put("time", System.currentTimeMillis());
            engine.put("svg", this.diagramCache);
            engine.put("t", (Object)this);
            engine.eval(script);
            this.diagramCache.updateTime(0.0);
            this.buffer = null;
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @INode.ClientSide
    public void registerEventAnimation(String event, String animation) {
        this.eventAnimations.put(event, animation);
    }

    @INode.ClientSide
    public void animateEvent(String event) {
        if (this.eventAnimations.containsKey(event)) {
            this.animate(this.eventAnimations.get(event));
        }
    }

    protected String parseSVG() {
        if (this.data == null) {
            return null;
        }
        try {
            this.dataHash = UUID.randomUUID().toString();
            ByteArrayInputStream is = new ByteArrayInputStream(this.data.getBytes("UTF-8"));
            SVGUniverse univ = SVGCache.getSVGUniverse();
            if (this.diagramCache != null) {
                univ.decRefCount(this.diagramCache.getXMLBase());
            }
            this.diagramCache = univ.getDiagram(SVGCache.getSVGUniverse().loadSVG((InputStream)is, this.dataHash), false);
            this.documentCache = this.data;
            try {
                this.setBounds((Rectangle2D)this.diagramCache.getRoot().getBoundingBox().clone());
            }
            catch (SVGException sVGException) {
                this.setBounds((Rectangle2D)this.diagramCache.getViewRect().clone());
            }
            univ.incRefCount(this.diagramCache.getXMLBase());
        }
        catch (IOException iOException) {
            this.diagramCache = null;
        }
        return this.dataHash;
    }

    private void print(SVGElement e, int indent) {
        int i = 0;
        while (i < indent) {
            System.err.print(" ");
            ++i;
        }
        System.err.println(e);
        i = 0;
        while (i < e.getNumChildren()) {
            this.print(e.getChild(i), indent + 2);
            ++i;
        }
        for (Object o : e.getPresentationAttributes()) {
            int i2 = 0;
            while (i2 < indent) {
                System.err.print(" ");
                ++i2;
            }
            System.err.print("  " + o);
            System.err.print("=");
            StyleAttribute sa = e.getPresAbsolute((String)o);
            System.err.println(sa.getStringValue());
        }
    }

    protected void initBuffer(Graphics2D g2d) {
        if (this.dataHash == null) {
            this.dataHash = this.parseSVG();
        }
        if (this.diagramCache == null) {
            System.out.println("UNABLE TO PARSE ANIMATED SVG:\n" + this.data);
            return;
        }
        this.diagramCache.setIgnoringClipHeuristic(true);
        this.buffer = this.diagramCache.getViewRect().getWidth() == 0.0 || this.diagramCache.getViewRect().getHeight() == 0.0 ? null : (this.useMipMap.booleanValue() ? (G2DUtils.isAccelerated((Graphics2D)g2d) ? new MipMapVRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new MipMapBufferedImage(this.diagramCache, this.bounds, this.targetSize)) : (G2DUtils.isAccelerated((Graphics2D)g2d) ? new VRamBufferedImage(this.diagramCache, this.bounds, this.targetSize) : new BufferedImage(this.diagramCache, this.bounds, this.targetSize)));
    }
}

