/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.content;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.diagram.content.Change;
import org.simantics.diagram.content.DiagramContentChanges;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.utils.datastructures.MapList;

public class DiagramContents {
    public List<Resource> elements = Collections.emptyList();
    public Set<Resource> nodeSet = Collections.emptySet();
    public Set<Resource> connectionSet = Collections.emptySet();
    public Set<EdgeResource> connectionSegments = Collections.emptySet();
    public Set<Resource> branchPoints = Collections.emptySet();
    public Set<Resource> routeGraphConnectionSet = Collections.emptySet();
    public Set<EdgeResource> routeLinks = Collections.emptySet();
    public Set<Resource> routeLines = Collections.emptySet();
    public Set<Resource> routePoints = Collections.emptySet();
    public Map<Object, Resource> partToConnection = Collections.emptyMap();
    public MapList<Resource, Object> connectionToParts = new MapList();

    private <T> void calculateChanges(Set<T> from, Set<T> to, Map<T, Change> result) {
        for (T e : to) {
            if (from.contains(e)) continue;
            result.put(e, Change.ADDED);
        }
        for (T e : from) {
            if (to.contains(e)) continue;
            result.put(e, Change.REMOVED);
        }
    }

    private <T> void addAll(Set<T> to, Map<T, Change> result) {
        for (T e : to) {
            result.put(e, Change.ADDED);
        }
    }

    public DiagramContentChanges differenceFrom(DiagramContents from) {
        DiagramContentChanges result = new DiagramContentChanges();
        if (this == from) {
            return result;
        }
        if (from == null) {
            this.addAll(this.nodeSet, result.elements);
            this.addAll(this.connectionSet, result.elements);
            this.addAll(this.routeGraphConnectionSet, result.elements);
            this.addAll(this.nodeSet, result.nodes);
            this.addAll(this.connectionSet, result.connections);
            this.addAll(this.connectionSegments, result.connectionSegments);
            this.addAll(this.branchPoints, result.branchPoints);
            this.addAll(this.routeGraphConnectionSet, result.routeGraphConnections);
            this.addAll(this.routeLinks, result.routeLinks);
            this.addAll(this.routeLines, result.routeLines);
            this.addAll(this.routePoints, result.routePoints);
        } else {
            this.calculateChanges(from.nodeSet, this.nodeSet, result.elements);
            this.calculateChanges(from.connectionSet, this.connectionSet, result.elements);
            this.calculateChanges(from.routeGraphConnectionSet, this.routeGraphConnectionSet, result.elements);
            this.calculateChanges(from.nodeSet, this.nodeSet, result.nodes);
            this.calculateChanges(from.connectionSet, this.connectionSet, result.connections);
            this.calculateChanges(from.connectionSegments, this.connectionSegments, result.connectionSegments);
            this.calculateChanges(from.branchPoints, this.branchPoints, result.branchPoints);
            this.calculateChanges(from.routeGraphConnectionSet, this.routeGraphConnectionSet, result.routeGraphConnections);
            this.calculateChanges(from.routeLinks, this.routeLinks, result.routeLinks);
            this.calculateChanges(from.routeLines, this.routeLines, result.routeLines);
            this.calculateChanges(from.routePoints, this.routePoints, result.routePoints);
            if (!from.elements.equals(this.elements)) {
                result.markElementOrderChanged();
            }
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.routeGraphConnectionSet == null ? 0 : this.routeGraphConnectionSet.hashCode());
        result = 31 * result + (this.connectionSet == null ? 0 : this.connectionSet.hashCode());
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramContents other = (DiagramContents)obj;
        if (!this.elements.equals(other.elements)) {
            return false;
        }
        if (!this.connectionSegments.equals(other.connectionSegments)) {
            return false;
        }
        if (!this.branchPoints.equals(other.branchPoints)) {
            return false;
        }
        if (!this.routeLinks.equals(other.routeLinks)) {
            return false;
        }
        if (!this.routeLines.equals(other.routeLines)) {
            return false;
        }
        return this.routePoints.equals(other.routePoints);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[elements=" + this.elements.size() + ", nodes=" + this.nodeSet.size() + ", connections=" + this.connectionSet.size() + ", branch points=" + this.branchPoints.size() + ", connection segments=" + this.connectionSegments.size() + ", routegraph connections=" + this.routeGraphConnectionSet.size() + ", routegraph links=" + this.routeLinks.size() + ", route lines=" + this.routeLines.size() + ", route points=" + this.routePoints.size() + "]";
    }
}

