/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.guarded.GuardedAsyncProcedureWrapper;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.adapter.ElementFactoryAdapter;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.elementclass.connection.ConnectionClass;
import org.simantics.g2d.routing.IRouter2;
import org.simantics.structural.stubs.StructuralResource2;

public class DefaultConnectionClassFactory
extends ElementFactoryAdapter {
    public static final ElementClass CLASS = ConnectionClass.CLASS;

    @Override
    public void create(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType, AsyncProcedure<ElementClass> procedure) {
        procedure.execute(graph, (Object)ConnectionClass.CLASS.newClassWith(false, new ElementHandler[]{new StaticObjectAdapter((Object)elementType)}));
    }

    @Override
    protected Resource getElementClassBaseType(AsyncReadGraph graph) {
        return ((DiagramResource)graph.getService(DiagramResource.class)).Connection;
    }

    @Override
    public void load(AsyncReadGraph graph, ICanvasContext canvas, IDiagram diagram, final Resource elementResource, final IElement element, final AsyncProcedure<IElement> procedure) {
        final GuardedAsyncProcedureWrapper guard = new GuardedAsyncProcedureWrapper(procedure, 1);
        DiagramGraphUtil.getPossibleRouter(graph, elementResource, new AsyncProcedure<IRouter2>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                guard.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, IRouter2 router) {
                if (router != null) {
                    element.setHint(DiagramHints.ROUTE_ALGORITHM, (Object)router);
                    procedure.execute(graph, (Object)element);
                } else {
                    DefaultConnectionClassFactory.this.loadConnectionTypeDefaultRouting(graph, element, elementResource, (AsyncProcedure<IElement>)guard);
                }
            }
        });
    }

    protected void loadConnectionTypeDefaultRouting(AsyncReadGraph graph, final IElement element, Resource elementResource, final AsyncProcedure<IElement> guard) {
        StructuralResource2 STR = (StructuralResource2)graph.getService(StructuralResource2.class);
        graph.forPossibleObject(elementResource, STR.HasConnectionType, (AsyncProcedure)new AsyncProcedure<Resource>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                guard.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, Resource connectionType) {
                DiagramResource DIA = (DiagramResource)graph.getService(DiagramResource.class);
                if (connectionType != null) {
                    graph.forPossibleObject(connectionType, DIA.HasDefaultRouting, (AsyncProcedure)new AsyncProcedure<Resource>(){

                        public void exception(AsyncReadGraph graph, Throwable throwable) {
                            guard.exception(graph, throwable);
                        }

                        public void execute(AsyncReadGraph graph, Resource routing) {
                            if (routing != null) {
                                graph.forPossibleAdapted(routing, IRouter2.class, (AsyncProcedure)new AsyncProcedure<IRouter2>(){

                                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                                        guard.exception(graph, throwable);
                                    }

                                    public void execute(AsyncReadGraph graph, IRouter2 router) {
                                        if (router != null) {
                                            element.setHint(DiagramHints.ROUTE_ALGORITHM, (Object)router);
                                        }
                                        guard.execute(graph, (Object)element);
                                    }
                                });
                            } else {
                                guard.execute(graph, (Object)element);
                            }
                        }
                    });
                } else {
                    guard.execute(graph, (Object)element);
                }
            }
        });
    }
}

