package org.simantics.diagram.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.simantics.db.Resource;
import org.simantics.scenegraph.profile.DataNodeMap;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Style;
import org.simantics.scenegraph.profile.common.ObserverGroupListener;
import org.simantics.scl.runtime.tuple.Tuple;
import org.simantics.scl.runtime.tuple.Tuple3;

/**
 * @author Antti Villberg
 * @since 1.36.0
 */
public class StyleBaseData {

    private static StyleBaseData INSTANCE;

    protected final Map<Tuple, Object> values   = new ConcurrentHashMap<>();

    private Map<Tuple3, ObserverGroupListener> listeners = new HashMap<>();

    private final Map<Style, List<Resource>> removals = new HashMap<>();

    private StyleBaseData() {
    }

    public static StyleBaseData getInstance() {
        if (INSTANCE == null) {
            synchronized (StyleBaseData.class) {
                if (INSTANCE == null) {
                    INSTANCE = new StyleBaseData();
                }
            }
        }
        return INSTANCE;
    }

    public void removeValue(Tuple t) {
        values.remove(t);
    }

    public void putValue(Tuple t, Object o) {
        values.put(t, o);
    }

    @SuppressWarnings("unchecked")
    public <T> T getValue(Tuple t) {
        return (T) values.get(t);
    }

    public synchronized void removeItem(Style s, Resource r) {
        List<Resource> l = removals.get(s);
        if (l == null) {
            l = new ArrayList<>();
            removals.put(s, l);
        }
        l.add(r);
    }

    public void putListener(Tuple3 key, ObserverGroupListener listener) {
        listeners.put(key, listener);
    }

    public void removeListener(Tuple3 key) {
        listeners.remove(key);
    }

    public ObserverGroupListener getListener(Tuple3 key) {
        return listeners.get(key);
    }

    public synchronized void applyRemovals(EvaluationContext evaluationContext, StyleBase<?> s) {
        List<Resource> rs = removals.remove(s);
        if (rs == null)
            return;

        DataNodeMap map = evaluationContext.getConstant(ProfileKeys.NODE_MAP);

        for (Resource item : rs) {
            s.cleanupStyleForItem(evaluationContext, map, item);
        }
    }

}
