package org.simantics.diagram.profile;

import java.awt.geom.AffineTransform;
import java.util.Arrays;

import org.simantics.common.color.Color;
import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.datatypes.literal.Vec2d;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.utils.Alignment;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.map.Tuple;

public class MonitorTextGridResult extends Tuple {
	
    public static class B extends Bean {
    	private static final Binding BINDING = Bindings.getBindingUnchecked(B.class);
    	public int index;
    	public double gain;
    	public double bias;
    	public B(int index, double gain, double bias) {
    		super(BINDING);
    		this.index = index;
    		this.gain = gain;
    		this.bias = bias;
    	}
    }
	
    public MonitorTextGridResult(String rowId, String text1, String text2, String text3, boolean enabled, boolean up, double spacing, Function1<String, String> modifier, Function1<String, String> validator, Function1<Vec2d, Boolean> translator, AffineTransform parentTransform) {
        super(rowId, text1, text2, text3, enabled, up, spacing, modifier, validator, translator, parentTransform, null, null, null, null, null, null, null, null);
    }
    public MonitorTextGridResult(String rowId, String text1, String text2, String text3, boolean enabled, boolean up, double spacing, Function1<String, String> modifier, Function1<String, String> validator, Function1<Vec2d, Boolean> translator, AffineTransform parentTransform, Vec2d offset) {
        super(rowId, text1, text2, text3, enabled, up, spacing, modifier, validator, translator, parentTransform, offset, null, null, null, null, null, null, null);
    }
    public MonitorTextGridResult(String rowId, String text1, String text2, String text3, boolean enabled, boolean up, double spacing, Function1<String, String> modifier, Function1<String, String> validator, Function1<Vec2d, Boolean> translator, AffineTransform parentTransform, Vec2d offset, Color color) {
        super(rowId, text1, text2, text3, enabled, up, spacing, modifier, validator, translator, parentTransform, offset, color, null, null, null, null, null, null);
    }
    public MonitorTextGridResult(String rowId, String text1, String text2, String text3, boolean enabled, boolean up, double spacing, Function1<String, String> modifier, Function1<String, String> validator, Function1<Vec2d, Boolean> translator, AffineTransform parentTransform, Vec2d offset, Color color, RVI rvi) {
        super(rowId, text1, text2, text3, enabled, up, spacing, modifier, validator, translator, parentTransform, offset, color, rvi, null, null, null, null, null);
    }
    public MonitorTextGridResult(String rowId, String text1, String text2, String text3, boolean enabled, boolean up, double spacing, Function1<String, String> modifier, Function1<String, String> validator, Function1<Vec2d, Boolean> translator, AffineTransform parentTransform, Vec2d offset, Color color, RVI rvi, Variable property, Formatter formatter, B b) {
        super(rowId, text1, text2, text3, enabled, up, spacing, modifier, validator, translator, parentTransform, offset, color, rvi, property, formatter, b, null, null);
    }
    public MonitorTextGridResult(String rowId, String text1, String text2, String text3, boolean enabled, boolean up, double spacing, Function1<String, String> modifier, Function1<String, String> validator, Function1<Vec2d, Boolean> translator, AffineTransform parentTransform, Vec2d offset, Color color, RVI rvi, Variable property, Formatter formatter, B b, Alignment[] alignment, Alignment[] verticalAlignment) {
        super(rowId, text1, text2, text3, enabled, up, spacing, modifier, validator, translator, parentTransform, offset, color, rvi, property, formatter, b, alignment, verticalAlignment);
    }
    private MonitorTextGridResult(Object ... fields) {
        super(fields);
    }
    public String getRowId() {
        return (String) getField(0);
    }
    public String getText1() {
        return (String) getField(1);
    }
    public String getText2() {
        return (String) getField(2);
    }
    public String getText3() {
        return (String) getField(3);
    }
    public Boolean getEnabled() {
        return (Boolean) getField(4);
    }
    public Boolean getUp() {
        return (Boolean) getField(5);
    }
    public Double getSpacing() {
        return (Double) getField(6);
    }
    @SuppressWarnings("unchecked")
    public Function1<String, String> getModifier() {
        return (Function1<String, String>) getField(7);
    }
    @SuppressWarnings("unchecked")
    public Function1<String, String> getValidator() {
        return (Function1<String, String>) getField(8);
    }
    @SuppressWarnings("unchecked")
    public Function1<Vec2d, Boolean> getTranslator() {
        return (Function1<Vec2d, Boolean>) getField(9);
    }
    public AffineTransform getParentTransform() {
        return (AffineTransform) getField(10);
    }
    public Vec2d getOffset() {
        return (Vec2d) getField(11);
    }
    public Color getColor() {
        return (Color) getField(12);
    }
    public RVI getRVI() {
        return (RVI) getField(13);
    }
    public Variable getProperty() {
        return (Variable) getField(14);
    }
    public Formatter getFormatter() {
        return (Formatter) getField(15);
    }
    public B getB() {
        return (B) getField(16);
    }
    public Alignment[] getAlignments() {
        return (Alignment[]) getField(17);
    }
    public Alignment[] getVerticalAlignments() {
        return (Alignment[]) getField(18);
    }
    public boolean getPending() {
        Boolean b = tryGetTypedField(19);
        return b != null && Boolean.TRUE.equals(b);
    }
    public Object getUnformattedValue() {
        return tryGetField(20);
    }
    public boolean sameStructure(MonitorTextGridResult other) {
    	Object[] fields = getFields();
    	Object[] otherFields = other.getFields();
    	int level = getLevel();
    	if (fields.length != otherFields.length)
    	    return false;
    	for(int i=0;i<2;i++) if(!ObjectUtils.objectEquals(fields[i],otherFields[i])) return false;
    	for(int i=3;i<level;i++) if(!ObjectUtils.objectEquals(fields[i],otherFields[i])) return false;
    	return true;
    }
    
    public MonitorTextGridResult withValue(Object unformattedValue, String value) {
        return withValue(unformattedValue, value, false);
    }

    public MonitorTextGridResult withValue(Object unformattedValue, String value, boolean pending) {
        boolean hasValue = unformattedValue != null;
        Object[] fs = Arrays.copyOf(getFields(), hasValue ? 21 : 20, Object[].class);
        fs[2] = value;
        fs[19] = pending;
        if (hasValue)
            fs[20] = unformattedValue;
        return new MonitorTextGridResult(fs);
    }

    public static MonitorTextGridResult make(ReadGraph graph, Resource element, int index, String id, String label, String value, String unit) throws DatabaseException {
		AffineTransform transform = DiagramGraphUtil.getAffineTransform(graph, element);
		Vec2d offset = DiagramGraphUtil.getOffset(graph, element);
		MonitorTextGridResult.B b = new MonitorTextGridResult.B(index, 1.0, 0.0);
    	return new MonitorTextGridResult(id, label, value, unit, true, true, 0.0, null, null, null, transform, offset, null, null, null, null, b, null, null);
    }
    
}