/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.internal;

import org.eclipse.core.runtime.Platform;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;

/**
 * @author Tuukka Lehtonen
 */
public final class DebugPolicy {

    public static boolean DEBUG = false;

    public static boolean DEBUG_GRAPH_WRITEBACK               = false;
    public static boolean DEBUG_GRAPH_WRITEBACK_MODIFICATION  = false;

    public static boolean DEBUG_TERMINAL_SEARCH               = false;

    public static boolean DEBUG_LOAD                          = false;
    public static boolean DEBUG_NODE_LOAD                     = false;
    public static boolean DEBUG_CONNECTION_LOAD               = false;
    public static boolean DEBUG_EDGE_LOAD                     = false;
    public static boolean DEBUG_CONNECTION_VISUALS_LOAD       = false;
    public static boolean DEBUG_TRANSFORM_LOAD                = false;

    public static double  DETERMINANT_LIMIT_HIGH              = 1e24;
    public static double  DETERMINANT_LIMIT_LOW               = 1e-24;
    public static double  TRANSLATION_LIMIT_HIGH              = 1e32;

    public static boolean DEBUG_EDGE_LISTENER                 = false;

    public static boolean DEBUG_GENERAL_ELEMENT_UPDATE        = false;
    public static boolean DEBUG_GENERAL_ELEMENT_UPDATE_DETAIL = false;
    public static boolean DEBUG_GRAPH_UPDATE                  = false;
    public static boolean DEBUG_DIAGRAM_UPDATE                = false;
    public static boolean DEBUG_DIAGRAM_UPDATE_DETAIL         = false;
    public static boolean DEBUG_NODE_UPDATE                   = false;
    public static boolean DEBUG_CONNECTION_UPDATE             = false;
    public static boolean DEBUG_EDGE_UPDATE                   = false;

    public static boolean DEBUG_LISTENER_BASE                 = false;
    public static boolean DEBUG_DIAGRAM_LISTENER              = false;
    public static boolean DEBUG_NODE_LISTENER                 = false;
    public static boolean DEBUG_CONNECTION_LISTENER           = false;

    /**
     * Enables tracing of
     * {@link IModifiableSynchronizationContext#set(org.simantics.utils.datastructures.hints.IHintContext.Key, Object)}
     * operations.
     */
    public static boolean DEBUG_SYNC_CONTEXT                 = false;

    public static boolean DEBUG_STATE                        = false;
    public static boolean DEBUG_MAPPING                      = false;
    public static boolean DEBUG_ELEMENT_LIFECYCLE            = false;
    public static boolean DEBUG_CONNECTION                   = false;

    public static boolean DEBUG_RELATIONSHIP                 = false;
    public static boolean DEBUG_GET_RELATIONSHIP             = false;

    public static boolean DEBUG_LAYERS                       = false;

    public static boolean DEBUG_MUTATOR                      = false;
    public static boolean DEBUG_MUTATOR_COMMIT               = false;

    public static boolean DEBUG_WRITE_TRANSACTIONS           = false;

    /**
     * Enables default copy paste handler debug output.
     */
    public static boolean DEBUG_COPY_PASTE                   = false;

    /**
     * This will disable all node/edge/diagram content query listeners from
     * performing updates. Maybe useful for debugging since
     * {@link GraphToDiagramSynchronizer} will only load the initial diagram
     * contents and process updates to those elements, but will not process
     * updates to the diagram structure.
     */
    public static boolean DISABLE_DIAGRAM_UPDATES            = false;

    /**
     * Indicates whether certain performance timings are performed and the
     * results printed out.
     */
    public static boolean PERFORM_TIMING                     = false;

    static {
        if (Activator.getDefault().isDebugging()) {
            DEBUG = true;
            String sTrue = Boolean.TRUE.toString();

            DEBUG_GRAPH_WRITEBACK = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/graphWriteback")); //$NON-NLS-1$
            DEBUG_GRAPH_WRITEBACK_MODIFICATION = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/graphWriteback/modifications")); //$NON-NLS-1$

            DEBUG_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load")); //$NON-NLS-1$
            DEBUG_NODE_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/node")); //$NON-NLS-1$
            DEBUG_CONNECTION_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/connection")); //$NON-NLS-1$
            DEBUG_EDGE_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/edge")); //$NON-NLS-1$
            DEBUG_CONNECTION_VISUALS_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/connectionVisuals")); //$NON-NLS-1$
            DEBUG_TERMINAL_SEARCH = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/terminalSearch")); //$NON-NLS-1$
            DEBUG_TRANSFORM_LOAD = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/transform")); //$NON-NLS-1$
            DETERMINANT_LIMIT_HIGH = parseDouble(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/transform/determinanLimitHigh"), DETERMINANT_LIMIT_HIGH); //$NON-NLS-1$
            DETERMINANT_LIMIT_LOW = parseDouble(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/transform/determinantLimitLow"), DETERMINANT_LIMIT_LOW); //$NON-NLS-1$
            TRANSLATION_LIMIT_HIGH = parseDouble(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/load/transform/translationLimitHigh"), TRANSLATION_LIMIT_HIGH); //$NON-NLS-1$

            DEBUG_GENERAL_ELEMENT_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/generalElementUpdate")); //$NON-NLS-1$
            DEBUG_GENERAL_ELEMENT_UPDATE_DETAIL = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/generalElementUpdate/detail")); //$NON-NLS-1$

            DEBUG_GRAPH_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/update")); //$NON-NLS-1$
            DEBUG_DIAGRAM_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/update/diagram")); //$NON-NLS-1$
            DEBUG_DIAGRAM_UPDATE_DETAIL = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/update/diagram/detail")); //$NON-NLS-1$
            DEBUG_NODE_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/update/node")); //$NON-NLS-1$
            DEBUG_CONNECTION_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/update/connection")); //$NON-NLS-1$
            DEBUG_EDGE_UPDATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/update/edge")); //$NON-NLS-1$

            DEBUG_LISTENER_BASE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/listener")); //$NON-NLS-1$
            DEBUG_DIAGRAM_LISTENER = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/listener/diagram")); //$NON-NLS-1$
            DEBUG_NODE_LISTENER = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/listener/node")); //$NON-NLS-1$
            DEBUG_CONNECTION_LISTENER = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/listener/connection")); //$NON-NLS-1$
            DEBUG_EDGE_LISTENER = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/listener/edge")); //$NON-NLS-1$

            DEBUG_SYNC_CONTEXT = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/context")); //$NON-NLS-1$

            DEBUG_STATE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/state")); //$NON-NLS-1$
            DEBUG_MAPPING = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/mapping")); //$NON-NLS-1$
            DEBUG_ELEMENT_LIFECYCLE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/elementLifecycle")); //$NON-NLS-1$
            DEBUG_CONNECTION = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/topology/connection")); //$NON-NLS-1$

            DEBUG_RELATIONSHIP = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/relationship")); //$NON-NLS-1$
            DEBUG_GET_RELATIONSHIP = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/relationship/get")); //$NON-NLS-1$

            DEBUG_LAYERS = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/layers")); //$NON-NLS-1$

            DEBUG_MUTATOR = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/mutator")); //$NON-NLS-1$
            DEBUG_MUTATOR_COMMIT = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/mutator/commit")); //$NON-NLS-1$

            DEBUG_WRITE_TRANSACTIONS = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/synchronizer/transactions/write")); //$NON-NLS-1$

            DEBUG_COPY_PASTE = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/debug/copyPaste")); //$NON-NLS-1$

            //--

            DISABLE_DIAGRAM_UPDATES = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/control/update/diagram/disable")); //$NON-NLS-1$

            //--

            PERFORM_TIMING = sTrue.equalsIgnoreCase(Platform.getDebugOption(Activator.PLUGIN_ID + "/perf/generalDiagramTiming")); //$NON-NLS-1$
        }
    }

    private static double parseDouble(String value, double defaultValue) {
        if (value == null)
            return defaultValue;
        try {
            return Double.parseDouble(value);
        } catch (NumberFormatException e) {
            return defaultValue;
        }
    }

}
