/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.content;

import java.awt.Shape;
import java.awt.geom.AffineTransform;

import org.simantics.db.Resource;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.g2d.diagram.handler.Topology.Terminal;
import org.simantics.g2d.element.handler.impl.ObjectTerminal;
import org.simantics.g2d.utils.geom.DirectionSet;
import org.simantics.utils.Container;
import org.simantics.utils.DataContainer;

/**
 * A default DB resource based implementation of the g2d {@link Terminal}
 * interface.
 * 
 * <p>
 * Elements that intend to contain terminal and use
 * {@link GraphToDiagramSynchronizer} must use this implementation to represent
 * the terminals of the element.
 * </p>
 * 
 * <p>
 * Also contains a relative transformation with respect to its parent, a set of
 * allowed drawing directions and a graphical shape to depict the terminal.
 * </p>
 * 
 * <p>
 * The specified terminal resource is expected to have at least the following
 * graph attached to it:
 * <pre>
 * specified-resource
 *     DIAGRAM.HasConnectionVariable
 *         _ : STRUCTURAL.ConnectionVariable
 *             STRUCTURAL.Binds TerminalRelation
 * </pre>
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public class ResourceTerminal extends ObjectTerminal {

    public ResourceTerminal(Resource r, AffineTransform transform, DirectionSet ds, Container<Shape> shape) {
        super(r, transform, ds, shape);
    }

    public ResourceTerminal(Resource r, AffineTransform transform, DirectionSet ds, Shape shape) {
        super(r, transform, ds, new DataContainer<Shape>(shape));
    }

    public ResourceTerminal(Resource r, AffineTransform transform, DirectionSet ds) {
        super(r, transform, ds);
    }

    public ResourceTerminal(Resource r, AffineTransform transform) {
        super(r, transform);
    }

    public ResourceTerminal(Resource r) {
        super(r, new AffineTransform());
    }

    public Resource getResource() {
        return (Resource) getData();
    }

}