/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.adapter;

import org.simantics.db.request.Read;
import org.simantics.g2d.canvas.ICanvasContext;

/**
 * A base for synchronous requests performed by
 * {@link GraphToDiagramSynchronizer}.
 * 
 * <p>
 * Takes care of making this request unique for this
 * {@link GraphToDiagramSynchronizer} instances by making the active
 * {@link ICanvasContext} a part of the requests identity.
 * </p>
 * 
 * @param <T> type of stored data element
 * @param <Result> query result type
 */
abstract class BaseRequest<T, Result> implements Read<Result> {

    final protected T    data;

    final int            hash;

    final ICanvasContext canvas;

    public BaseRequest(ICanvasContext canvas, T data) {
        this.canvas = canvas;
        assert canvas != null;
        assert data != null;
        this.data = data;
        this.hash = data.hashCode() + 31 * canvas.hashCode();
    }

    @Override
    public int hashCode() {
        return hash;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other)
            return true;
        if (other == null || getClass() != other.getClass())
            return false;
        BaseRequest<?, ?> o = (BaseRequest<?, ?>) other;
        return data.equals(o.data) && canvas.equals(o.canvas);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + "[" + data + " - " + canvas.hashCode() + "]";
    }

}