package org.simantics.diagram.profile.view;

import java.util.List;

import org.eclipse.jface.viewers.ISelection;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.ModelledActionImpl;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.utils.ui.ISelectionUtils;

public class RemoveEntriesAction extends ModelledActionImpl<Resource> {

	public RemoveEntriesAction(Resource configuration) {
		super(configuration);
	}
	
	public void run(Resource runtimeDiagram) {

		ISelection selection = getParameter(DiagramResource.URIs.ProfilesView_SelectedEntries);
        final List<ProfileTuple> selectedEntries = ISelectionUtils.getPossibleKeys(selection, SelectionHints.KEY_MAIN, ProfileTuple.class);
        if(selectedEntries != null && !selectedEntries.isEmpty()) {
            try {
                Simantics.getSession().syncRequest(new WriteRequest() {

                    @Override
                    public void perform(WriteGraph graph) throws DatabaseException {
                    	
                    	DiagramResource DIA = DiagramResource.getInstance(graph);
                    	for(ProfileTuple entry : selectedEntries) {
                        	Resource list = graph.getPossibleObject(entry.getBaseProfile(), DIA.HasEntries);
                    		OrderedSetUtils.remove(graph, list, entry.getEntry());
                    	}
                        
                    }

                });
            } catch (DatabaseException e) {
                e.printStackTrace();
            }
        }

	}

}
