/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.diagram.profile.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.diagram.stubs.DiagramResource;

public class AvailableGroups extends ViewpointContributor<Resource> {

    @Override
    public Collection<?> getContribution(ReadGraph graph, Resource runtimeDiagram) throws DatabaseException {
    	
        DiagramResource dr = DiagramResource.getInstance(graph);
        String modelURI = graph.getPossibleRelatedValue((Resource)runtimeDiagram, dr.RuntimeDiagram_HasModelURI);
        if (modelURI == null)
            return Collections.emptyList();

        Resource model = graph.getPossibleResource(modelURI);
        if (model == null)
            return Collections.emptyList();

        Instances query = graph.adapt(dr.Group, Instances.class);
        
        ArrayList<Resource> result = new ArrayList<Resource>();
        result.addAll(query.find(graph, model));
        result.addAll(graph.syncRequest(new ObjectsWithType(model, L0.ConsistsOf, dr.Group)));
        return result; 
    	
    }

}
