/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.tests.actions;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLineHalf;
import org.simantics.diagram.connection.actions.IAction;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;

public class HighlightReconnectPointsAction
implements IAction {
    public static final double DEGENERATED_LINE_LENGTH = 0.8;
    public static final double CROSS_SIZE = 0.5;
    RouteGraph rg;
    double crossSize;

    public HighlightReconnectPointsAction(RouteGraph rg) {
        this(rg, 0.5);
    }

    public HighlightReconnectPointsAction(RouteGraph rg, double crossSize) {
        this.rg = rg;
        this.crossSize = crossSize;
    }

    @Override
    public void render(Graphics2D g, IRouteGraphRenderer renderer, double mouseX, double mouseY) {
        renderer.render(g, this.rg);
        for (RouteLineHalf lh : this.rg.getLineHalves()) {
            if (lh.getLine().getLength() < 0.8) continue;
            double x = lh.getLink().getX();
            double y = lh.getLink().getY();
            if (lh.getLine().isHorizontal()) {
                x = lh.getLink() == lh.getLine().getBegin() ? (x += this.crossSize * 2.0) : (x -= this.crossSize * 2.0);
            } else {
                y = lh.getLink() == lh.getLine().getBegin() ? (y += this.crossSize * 2.0) : (y -= this.crossSize * 2.0);
            }
            g.draw(new Line2D.Double(x - this.crossSize, y - this.crossSize, x + this.crossSize, y + this.crossSize));
            g.draw(new Line2D.Double(x - this.crossSize, y + this.crossSize, x + this.crossSize, y - this.crossSize));
        }
    }
}

