/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import gnu.trove.map.hash.THashMap;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.simantics.diagram.connection.Directions;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminalPosition;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;

public class RouteTerminal
extends RoutePoint
implements RouteNode,
Serializable {
    private static final long serialVersionUID = -8839093950347737029L;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_DOWN = 2;
    public static final int DIR_LEFT = 4;
    public static final int DIR_UP = 8;
    public static final int DIR_DIRECT = 16;
    private Object data;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private int allowedDirections;
    private ILineEndStyle style;
    private ILineEndStyle dynamicStyle;
    private boolean routeToBounds;
    private RouteTerminalPosition dynamicPosition;
    RouteLine line;

    public RouteTerminal(double x, double y, double minX, double minY, double maxX, double maxY, int allowedDirections, boolean routeToBounds, ILineEndStyle style, RouteTerminalPosition dynamicPosition) {
        super(x, y);
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.allowedDirections = allowedDirections;
        this.routeToBounds = routeToBounds;
        this.style = style;
        this.dynamicPosition = dynamicPosition;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public int getAllowedDirections() {
        return this.allowedDirections;
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public Rectangle2D getBounds() {
        return new Rectangle2D.Double(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    protected void route(ArrayList<RouteLine> lines, RouteGraph.IntervalCache cache, boolean boundingBoxesIntersect) {
        block28: {
            int dir;
            boolean routeLineDoesNotIntersectTerminal;
            int lineDir;
            block31: {
                block30: {
                    block29: {
                        block27: {
                            boolean routeLineDoesNotIntersectTerminal2;
                            int lineDir2;
                            if (!this.routeToBounds) break block27;
                            double linePosition = this.line.position;
                            if (this.line.isHorizontal) {
                                lineDir2 = linePosition < this.y ? 3 : 1;
                                routeLineDoesNotIntersectTerminal2 = linePosition <= this.minY || linePosition >= this.maxY;
                            } else {
                                lineDir2 = linePosition < this.x ? 2 : 0;
                                boolean bl = routeLineDoesNotIntersectTerminal2 = linePosition <= this.minX || linePosition >= this.maxX;
                            }
                            if (routeLineDoesNotIntersectTerminal2) {
                                RouteLine line0 = this.createLine0(lineDir2);
                                new RouteLink(line0, this.line);
                                lines.add(line0);
                                switch (lineDir2) {
                                    case 0: {
                                        this.x = this.maxX;
                                        this.y = 0.5 * (this.minY + this.maxY);
                                        break;
                                    }
                                    case 1: {
                                        this.x = 0.5 * (this.minX + this.maxX);
                                        this.y = this.maxY;
                                        break;
                                    }
                                    case 2: {
                                        this.x = this.minX;
                                        this.y = 0.5 * (this.minY + this.maxY);
                                        break;
                                    }
                                    case 3: {
                                        this.x = 0.5 * (this.minX + this.maxX);
                                        this.y = this.minY;
                                    }
                                }
                                return;
                            }
                            if (!this.line.getPoints().contains(this)) {
                                this.line.addPoint(this);
                            }
                            RouteGraph.Interval interval = cache.get(this.line);
                            if (this.line.isHorizontal) {
                                this.x = interval.min < this.minX ? this.minX : this.maxX;
                                this.y = linePosition;
                            } else {
                                this.x = linePosition;
                                this.y = interval.min < this.minY ? this.minY : this.maxY;
                            }
                            break block28;
                        }
                        double linePosition = this.line.position;
                        if (this.line.isHorizontal) {
                            if (linePosition == this.y) {
                                this.line.addPoint(this);
                                return;
                            }
                            lineDir = linePosition < this.y ? 3 : 1;
                            routeLineDoesNotIntersectTerminal = linePosition <= this.minY || linePosition >= this.maxY || boundingBoxesIntersect;
                        } else {
                            if (linePosition == this.x) {
                                this.line.addPoint(this);
                                return;
                            }
                            lineDir = linePosition < this.x ? 2 : 0;
                            boolean bl = routeLineDoesNotIntersectTerminal = linePosition <= this.minX || linePosition >= this.maxX || boundingBoxesIntersect;
                        }
                        if ((routeLineDoesNotIntersectTerminal || this.line.isHorizontal && (this.x == this.minX || this.x == this.maxX) || !this.line.isHorizontal && (this.y == this.minY || this.y == this.maxY)) && Directions.isAllowed(this.allowedDirections, lineDir)) {
                            RouteLine line0 = this.createLine0(lineDir);
                            new RouteLink(line0, this.line);
                            lines.add(line0);
                            return;
                        }
                        dir = 1 - (lineDir & 1);
                        if (!Directions.isAllowed(this.allowedDirections, dir)) break block29;
                        if (Directions.isAllowed(this.allowedDirections, dir + 2)) {
                            RouteGraph.Interval interval = cache.get(this.line);
                            if (dir == 0) {
                                if (interval.max <= this.maxX) {
                                    dir = 2;
                                }
                            } else if (interval.max <= this.maxY) {
                                dir = 3;
                            }
                        }
                        break block30;
                    }
                    if (!Directions.isAllowed(this.allowedDirections, dir + 2)) break block31;
                    dir += 2;
                }
                RouteLine line0 = this.createLine0(dir);
                RouteLine line1 = this.createLine1(dir);
                new RouteLink(line0, line1);
                new RouteLink(line1, this.line);
                lines.add(line0);
                lines.add(line1);
                line0.nextTransient = line1;
                return;
            }
            if (!routeLineDoesNotIntersectTerminal && Directions.isAllowed(this.allowedDirections, lineDir)) {
                RouteLine line0 = this.createLine0(lineDir);
                RouteLine line1 = this.createLine1(lineDir);
                RouteLine line2 = this.createLine2(lineDir, cache);
                new RouteLink(line0, line1);
                new RouteLink(line1, line2);
                new RouteLink(line2, this.line);
                lines.add(line0);
                lines.add(line1);
                lines.add(line2);
                line0.nextTransient = line1;
                line1.nextTransient = line2;
                return;
            }
            dir = lineDir ^ 2;
            RouteLine line0 = this.createLine0(dir);
            RouteLine line1 = this.createLine1(dir);
            RouteLine line2 = this.createLine2(dir, cache);
            new RouteLink(line0, line1);
            new RouteLink(line1, line2);
            new RouteLink(line2, this.line);
            lines.add(line0);
            lines.add(line1);
            lines.add(line2);
            line0.nextTransient = line1;
            line1.nextTransient = line2;
            return;
        }
    }

    protected RouteLine createLine0(int dir) {
        RouteLine line0 = (dir & 1) == 0 ? new RouteLine(true, this.y) : new RouteLine(false, this.x);
        line0.addPoint(this);
        line0.terminal = this;
        return line0;
    }

    private RouteLine createLine1(int dir) {
        RouteLine line1 = (dir & 1) == 0 ? new RouteLine(false, (dir & 2) == 0 ? this.maxX : this.minX) : new RouteLine(true, (dir & 2) == 0 ? this.maxY : this.minY);
        line1.terminal = this;
        return line1;
    }

    private RouteLine createLine2(int dir, RouteGraph.IntervalCache cache) {
        RouteLine line2;
        RouteGraph.Interval interval = cache.get(this.line);
        if ((dir & 1) == 0) {
            double position = this.minY < interval.min ? (this.maxY > interval.max ? (2.0 * this.maxY - this.y - interval.max < interval.min + this.y - 2.0 * this.minY ? this.maxY : this.minY) : this.maxY) : (this.maxY > interval.max ? this.minY : (this.maxY - this.y < this.y - this.minY ? this.maxY : this.minY));
            line2 = new RouteLine(true, position);
        } else {
            double position = this.minX < interval.min ? (this.maxX > interval.max ? (2.0 * this.maxX - this.x - interval.max < interval.min + this.x - 2.0 * this.minX ? this.maxX : this.minX) : this.maxX) : (this.maxX > interval.max ? this.minX : (this.maxX - this.x < this.x - this.minX ? this.maxX : this.minX));
            line2 = new RouteLine(false, position);
        }
        line2.terminal = this;
        return line2;
    }

    public boolean isNear(double x2, double y2) {
        return this.minX <= x2 && x2 <= this.maxX && this.minY <= y2 && y2 <= this.maxY;
    }

    void setLocation(double x2, double y2) {
        double dx = x2 - this.x;
        double dy = y2 - this.y;
        this.x = x2;
        this.y = y2;
        this.minX += dx;
        this.minY += dy;
        this.maxX += dx;
        this.maxY += dy;
    }

    void rotate(int amount) {
        if ((amount %= 4) < 0) {
            amount += 4;
        }
        int temp = (this.allowedDirections & 0xF) << amount;
        this.allowedDirections = temp & 0xF | temp >> 4 | this.allowedDirections & 0x10;
    }

    public double approximatePositionToLine() {
        int lineDir;
        int n = this.line.isHorizontal ? (this.line.position < this.y ? 3 : 1) : (lineDir = this.line.position < this.x ? 2 : 0);
        if (Directions.isAllowed(this.allowedDirections, lineDir)) {
            return this.line.isHorizontal ? this.x : this.y;
        }
        int dir = 0;
        while (dir < 4) {
            if (Directions.isAllowed(this.allowedDirections, dir) && ((dir ^ lineDir) & 1) == 1) {
                switch (dir) {
                    case 0: {
                        return this.maxX;
                    }
                    case 1: {
                        return this.maxY;
                    }
                    case 2: {
                        return this.minX;
                    }
                    case 3: {
                        return this.minY;
                    }
                }
            }
            ++dir;
        }
        return this.line.isHorizontal ? this.x : this.y;
    }

    @Override
    public RouteTerminal copy(THashMap<Object, Object> map) {
        RouteTerminal copy = (RouteTerminal)map.get((Object)this);
        if (copy == null) {
            copy = new RouteTerminal(this.x, this.y, this.minX, this.minY, this.maxX, this.maxY, this.allowedDirections, this.routeToBounds, this.style, this.dynamicPosition);
            copy.setDynamicStyle(this.dynamicStyle);
            map.put((Object)this, (Object)copy);
            copy.data = this.data;
            copy.line = this.line == null ? null : this.line.copy(map);
        }
        return copy;
    }

    public void print(PrintStream out) {
        out.print("     (" + this.x + "," + this.y + ") " + this.allowedDirections + " -> ");
        if (this.line != null) {
            this.line.print(out);
        } else {
            out.print("NO LINE");
        }
        out.print(" (data=" + this.data + ")");
        out.println();
    }

    public ILineEndStyle getStyle() {
        return this.style;
    }

    public ILineEndStyle getRenderStyle() {
        if (this.dynamicStyle != null) {
            return this.dynamicStyle;
        }
        return this.style;
    }

    public boolean hasDirectConnection() {
        return (this.allowedDirections & 0x10) == 16;
    }

    public RouteLine getLine() {
        return this.line;
    }

    public void setLine(RouteLine line) {
        this.line = line;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public void toggleDirectLines() {
        this.allowedDirections ^= 0x10;
    }

    public boolean isRouteToBounds() {
        return this.routeToBounds;
    }

    public void setStyle(ILineEndStyle style) {
        this.style = style;
    }

    public ILineEndStyle getDynamicStyle() {
        return this.dynamicStyle;
    }

    public void setDynamicStyle(ILineEndStyle dynamicStyle) {
        this.dynamicStyle = dynamicStyle;
    }

    public RouteTerminalPosition getDynamicPosition() {
        return this.dynamicPosition;
    }

    public boolean updateDynamicPosition() {
        AffineTransform tr;
        boolean changed = false;
        if (this.dynamicPosition != null && (tr = this.dynamicPosition.getTransform()) != null) {
            double nx = tr.getTranslateX();
            changed |= this.x != nx;
            this.x = nx;
            double ny = tr.getTranslateY();
            changed |= this.y != ny;
            this.y = ny;
        }
        return changed;
    }
}

