/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.desktop.ui.internal;

import java.io.File;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.DatabaseJob;
import org.simantics.modeling.ModelingUtils;

public class ImportModel extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        
        // Get imported transferable graph file using FileDialog
        Shell shell = HandlerUtil.getActiveShellChecked(event);
        FileDialog fd = new FileDialog(shell, SWT.OPEN);
        fd.setText(Messages.ImportModel_ImportModel);

        String path = Activator.getDefault().getPreferenceStore().getString("IMPORT_MODEL_PATH"); //$NON-NLS-1$
        if(path.isEmpty() || !(new File(path).exists())){
        	path = System.getProperty("user.dir"); //$NON-NLS-1$
        }
        
        fd.setFilterPath(path);
        String[] filterExt = {"*.tg", "*.*"}; //$NON-NLS-1$ //$NON-NLS-2$
        fd.setFilterExtensions(filterExt);
        final String selected = fd.open();
        if(selected == null) return null;

        Job job = new DatabaseJob(Messages.ImportModel_DatabaseImportModel) { 

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                ModelingUtils.importModel(selected);
                return Status.OK_STATUS;
            }
        };
        
        job.setUser(true);
        job.schedule();

        return null;
        
    }

}
