/*******************************************************************************
 * Copyright (c) 2007, 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *     Semantum Oy - refactoring (#6855)
 *******************************************************************************/
package org.simantics.debug.ui.internal;

import java.util.function.BiConsumer;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.ui.ResourceSearch;
import org.simantics.debug.ui.SearchResourceDialog;
import org.simantics.ui.workbench.action.ChooseActionRequest;
import org.simantics.utils.Container;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SearchResourceHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell shell = HandlerUtil.getActiveShellChecked(event);
        Session session = Simantics.getSession();
        SearchResourceDialog rld = new SearchResourceDialog(session, false, shell, Messages.SearchResourceHandler_OpenResource);
        rld.setResourceFilter(ResourceSearch.FILTER_ALL);
        rld.setBlockOnOpen(true);
        rld.open();
        if (rld.getResult() == null)
            return null;

        String currentPerspectiveId = WorkbenchUtils.getCurrentPerspectiveId();

        for (Object o : rld.getResult()) {
            @SuppressWarnings("unchecked")
            Container<Resource> rc = (Container<Resource>) o;
            openPreferredEditor(shell, session, rc.get(), currentPerspectiveId);
        }

        return null;
    }

    private static void openPreferredEditor(Shell parent, Session s, Resource r, String defaultPerspective) {
        findActions(s, r, defaultPerspective, (resourceName, actions) -> {
            SWTUtils.asyncExec(parent, () -> {
                IAction action = ChooseActionRequest.chooseAction(parent, actions, resourceName);
                if (action != null)
                    action.run();
            });
        });
    }

    private static void findActions(Session s, Resource r, String defaultPerspective, BiConsumer<String, IPriorityAction[]> consumer) {
        s.asyncRequest(new ReadRequest() {
            @Override
            public void run(ReadGraph g) throws DatabaseException {
                String resourceName = NameUtils.getSafeName(g, r);
                IPriorityAction[] actions = ChooseActionRequest.findActions(g, r, defaultPerspective);
                if (actions != null)
                    consumer.accept(resourceName, actions);
            }
        });
    }

}
