/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical.model;

import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.graphical.LabelingPreferences;
import org.simantics.layer0.Layer0;

public class NodeData {
    Resource resource;
    String[] labels;
    ArrayList<Statement> statements = new ArrayList();

    public NodeData(Resource resource) {
        this.resource = resource;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void updateData(ReadGraph g, LabelingPreferences pref) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)g);
        Resource name = null;
        Resource label = null;
        ArrayList<Resource> types = new ArrayList<Resource>();
        ArrayList<Resource> tags = new ArrayList<Resource>();
        this.statements.clear();
        for (Statement stat : g.getStatements(this.resource, L0.IsWeaklyRelatedTo)) {
            if (!stat.getSubject().equals(this.resource)) continue;
            Resource predicate = stat.getPredicate();
            if (predicate.equals(L0.InstanceOf)) {
                types.add(stat.getObject());
                continue;
            }
            if (predicate.equals(L0.HasName)) {
                name = stat.getObject();
                continue;
            }
            if (predicate.equals(L0.HasLabel)) {
                label = stat.getObject();
                continue;
            }
            if (this.resource.equals(stat.getObject())) {
                tags.add(predicate);
                continue;
            }
            if (g.isSubrelationOf(predicate, L0.HasNext) || g.isSubrelationOf(predicate, L0.HasPrevious)) continue;
            this.statements.add(stat);
        }
        ArrayList<String> labels = new ArrayList<String>(4);
        labels.add("$" + this.resource.getResourceId());
        if (name != null) {
            labels.add((String)g.getValue(name, (Binding)Bindings.STRING));
        }
        if (label != null) {
            labels.add((String)g.getValue(label, (Binding)Bindings.STRING));
        }
        for (Resource type : types) {
            labels.add(": " + NameUtils.getSafeName((ReadGraph)g, (Resource)type));
        }
        for (Resource tag : tags) {
            labels.add("TAG " + NameUtils.getSafeName((ReadGraph)g, (Resource)tag));
        }
        this.labels = labels.toArray(new String[labels.size()]);
    }

    public Resource getResource() {
        return this.resource;
    }

    public ArrayList<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(ArrayList<Statement> statements) {
        this.statements = statements;
    }
}

