/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.graphical;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class UsefulKeyAdapter
implements KeyListener,
Runnable {
    private final KeyListener gKeyListener;
    private final BlockingQueue<KeyEvent> gQueue = new ArrayBlockingQueue<KeyEvent>(100);
    private final Thread gRunner;
    private boolean gRunning = true;
    private int gMaxAge;

    public UsefulKeyAdapter(KeyListener keyListener) {
        this(keyListener, 10);
    }

    @Override
    public void run() {
        while (this.gRunning) {
            try {
                KeyEvent ev = this.gQueue.take();
                if (ev.getID() == 402) {
                    KeyEvent ev2 = this.gQueue.poll(this.gMaxAge, TimeUnit.MILLISECONDS);
                    if (this.matches(ev, ev2)) continue;
                    this.dispatchEvent(ev);
                    this.dispatchEvent(ev2);
                    continue;
                }
                this.dispatchEvent(ev);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public UsefulKeyAdapter(KeyListener keyListener, int maxAge) {
        this.gKeyListener = keyListener;
        this.gMaxAge = maxAge;
        this.gRunner = new Thread(this);
        this.gRunner.setName("UsefulKeyAdapter-Thread");
        this.gRunner.setDaemon(true);
        this.gRunner.start();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.gQueue.offer(e);
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.gQueue.offer(e);
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.gKeyListener.keyTyped(e);
    }

    private void dispatchEvent(KeyEvent e) {
        if (e == null) {
            return;
        }
        if (e.getID() == 401) {
            this.gKeyListener.keyPressed(e);
        } else if (e.getID() == 402) {
            this.gKeyListener.keyReleased(e);
        }
    }

    private boolean matches(KeyEvent e1, KeyEvent e2) {
        if (e1 == e2) {
            return true;
        }
        if (e2 == null) {
            return false;
        }
        return e1.getID() == 402 && e2.getID() == 401 && e1.getKeyCode() == e2.getKeyCode() && e1.getKeyChar() == e2.getKeyChar() && e2.getWhen() <= e1.getWhen() + (long)this.gMaxAge;
    }

    protected void finalize() throws Throwable {
        this.gRunning = false;
        this.gRunner.interrupt();
        super.finalize();
    }
}

