/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.ui;

import java.net.URL;

import javax.inject.Named;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.simantics.db.Resource;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.debug.browser.internal.DebugBrowserServer;
import org.simantics.utils.ui.ISelectionUtils;

/**
 * @author Jani Simomaa / Semantum Oy
 * @author Tuukka Lehtonen / Semantum Oy
 * @since 1.22
 */
public class LaunchDebugBrowser {

    private static int browserCounter = 0;

    @CanExecute
    public boolean canExecute() {
        return Platform.inDevelopmentMode();
    }

    @Execute
    public void execute(
            @Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
            @Named(IServiceConstants.ACTIVE_SELECTION) ISelection selection)
    {
        try {
            // Start Jetty server for graph debugging
            DebugBrowserServer server = org.simantics.debug.browser.internal.Activator.getDefault().startDebugServer();
            URL url = server.getURL();

            // Get default input from current workbench selection
            Resource input = ISelectionUtils.getSinglePossibleKey(selection, SelectionHints.KEY_MAIN, Resource.class, true);
            URL inputUrl = input != null ? new URL(url.toExternalForm() + "/" + input.getResourceId()) : url;

            // Open browser
            IWorkbenchBrowserSupport bs = PlatformUI.getWorkbench().getBrowserSupport();
            if (bs.isInternalWebBrowserAvailable()) {
                IWebBrowser browser = bs.createBrowser(
                        IWorkbenchBrowserSupport.AS_EDITOR
                        | IWorkbenchBrowserSupport.NAVIGATION_BAR
                        | IWorkbenchBrowserSupport.LOCATION_BAR
                        , "graph.debug.browser." + (browserCounter++),
                        "Database Debug Browser",
                        url.toString());
                browser.openURL(inputUrl);
            } else {
                bs.getExternalBrowser().openURL(inputUrl);
            }
        } catch (Exception e) {
            Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "Failed to open external browser.", e));
            ErrorDialog.openError(activeShell,
                    "Failed to Open External Browser",
                    "Failed to open debug browser in the default external web browser. See exception for details.",
                    new Status(Status.ERROR, Activator.PLUGIN_ID, "", e));
        }
    }

}
