/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.internal;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.simantics.debug.browser.servlet.ResourceBrowserServlet;

/**
 * @author Jani Simomaa / Semantum Oy
 * @since 1.22
 */
public class DebugBrowserServer {

    private static final String CONTEXT_PATH = "/debug";
    
    private final Server server;
    private final ServerConnector connector;

    public DebugBrowserServer(String resourcePath) throws Exception {
        server = new Server();
        
        connector = new ServerConnector(server);
        connector.setHost("localhost");
        connector.setPort(0);
        server.setConnectors(new Connector[] { connector } );
        
        ServletHandler handler = new ServletHandler();
        
        ServletHolder holder = new ServletHolder(ResourceBrowserServlet.class);
        handler.addServletWithMapping(holder, "/*");
        ServletContextHandler contextHandler = new ServletContextHandler(ServletContextHandler.SESSIONS);
        contextHandler.setContextPath(CONTEXT_PATH);
        contextHandler.setHandler(handler);
        
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(resourcePath);
 
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[] { resourceHandler, contextHandler });
        server.setHandler(handlers);
    }
    
    public void start() throws Exception {
        server.start();
    }
    
    public void stop() throws Exception {
        server.stop();
    }
    
    public URL getURL() {
        try {
            return new URL("http", connector.getHost(), connector.getLocalPort(), CONTEXT_PATH);
        } catch (MalformedURLException e) {
            Platform.getLog(Activator.getContext().getBundle()).log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, "URL construction failed", e));
            throw new Error(e);
        }
    }
    
}
