/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.testing.base;

import gnu.trove.map.hash.THashMap;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.osgi.framework.BundleContext;
import org.simantics.db.testing.cases.FreshDatabaseTest;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.compiler.testing.repository.TestRepository;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.osgi.internal.Activator;
import org.simantics.scl.osgi.internal.ServiceBasedModuleSourceRepository;
import org.simantics.scl.osgi.internal.ServiceBasedTestRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLScriptTestBase
extends FreshDatabaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCLScriptTestBase.class);
    private Map<String, TestRunnable> testRunnables = new THashMap();
    @Rule
    public TestName testName = new TestName();

    public SCLScriptTestBase() {
        BundleContext context = Activator.getContext();
        ArrayList runnables = new ArrayList();
        ((TestRepository)context.getService(context.getServiceReference(TestRepository.class))).collectTests(runnables);
        for (TestRunnable runnable : runnables) {
            this.testRunnables.put(runnable.getName(), runnable);
        }
    }

    protected void test() {
        this.test(-1);
    }

    protected void test(int timeout) {
        this.testImpl(timeout);
    }

    private void testImpl(final int timeout) {
        SCLOsgi.SOURCE_REPOSITORY = new ServiceBasedModuleSourceRepository(Activator.getContext());
        SCLOsgi.MODULE_REPOSITORY = new ModuleRepository(SCLOsgi.SOURCE_REPOSITORY);
        SCLOsgi.TEST_REPOSITORY = new ServiceBasedTestRepository(Activator.getContext());
        String testName = this.resolveTestName();
        TestRunnable runnable = this.testRunnables.get(testName);
        if (runnable == null) {
            LOGGER.error("SCL Test Suite file (.sts) for test {} cannot be found from test repository.", (Object)testName);
            return;
        }
        long start = System.nanoTime();
        if (timeout > -1) {
            LOGGER.info("Running test {} with a timeout of {} seconds", (Object)testName, (Object)timeout);
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    LOGGER.info("Watchdog will kill this test process because it has been executing for over {} seconds", (Object)timeout);
                    String processName = ManagementFactory.getRuntimeMXBean().getName();
                    LOGGER.info("Test Process Name: {}", (Object)processName);
                    String PID = processName.split("@")[0];
                    String command = "taskkill /F /PID " + PID;
                    LOGGER.info("Running command to kill test process: {}", (Object)command);
                    try {
                        Runtime.getRuntime().exec(command);
                    }
                    catch (IOException e) {
                        LOGGER.error("Failed to kill process that ran over its execution time limit of {} seconds", (Object)timeout, (Object)e);
                    }
                }
            }, timeout * 1000);
            try {
                try {
                    runnable.run();
                    long end = System.nanoTime();
                    LOGGER.info("Completed test {} execution in {} seconds", (Object)testName, (Object)String.format("%.3f", (double)(end - start) * 1.0E-9));
                }
                catch (Exception e) {
                    LOGGER.error("Failed to run test {} runnable {}", new Object[]{testName, runnable, e});
                    timer.cancel();
                }
            }
            finally {
                timer.cancel();
            }
        } else {
            LOGGER.info("Running test {} without timeout", (Object)testName);
            try {
                runnable.run();
                long end = System.nanoTime();
                LOGGER.info("Completed test {} execution in {} seconds", (Object)testName, (Object)String.format("%.3f", (double)(end - start) * 1.0E-9));
            }
            catch (Exception e) {
                LOGGER.error("Failed to run test {} runnable {}", new Object[]{testName, runnable, e});
            }
        }
    }

    private String resolveTestName() {
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = this.getClass();
        while (clazz.getName() != SCLScriptTestBase.class.getName()) {
            String[] classNameParts = clazz.getName().split("\\.");
            sb.insert(0, "/");
            sb.insert(0, classNameParts[classNameParts.length - 1]);
            clazz = clazz.getSuperclass();
        }
        sb.append(this.testName.getMethodName());
        return sb.toString();
    }
}

