package org.simantics.db.testing.common;


import org.simantics.db.ServerI;
import org.simantics.db.exception.DatabaseException;

public class Server4Remote implements ServerI {
    private boolean active = false;
    private String host = null;
    private int port = 0;
    public Server4Remote(String host, int port) {
        this.host = host;
        this.port = port;
    }

    @Override
    public void start() throws DatabaseException {
        active = true;
    }

    @Override
    public void stop() throws DatabaseException {
        active = false;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public String getAddress() throws DatabaseException {
        return "" + host + ":" + port;
    }

//    @Override
//    public synchronized ServerAddress getServerAddress()
//    throws DatabaseException {
//        return new ServerAddress(host, port);
//    }

    @Override
    public String execute(String command) throws DatabaseException {
        throw new DatabaseException("Execute method not supported for remote server.");
    }

    @Override
    public String executeAndDisconnect(String command) throws DatabaseException {
        throw new DatabaseException("ExecuteAndDisconnect method not supported for remote server.");
    }

}
