/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.procedure;


/**
 * @author Antti Villberg
 * 
 * First execute is called k times. After this finished or exception is called exactly once.
 *
 * @param <Result> the result object type accepted by the procedure
 */
public interface MultiProcedure<Result> {
    
    void execute(Result result);
    void finished();
    void exception(Throwable throwable);
	
}
