/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.function;

import org.simantics.db.exception.DatabaseException;

/**
 * Represents a supplier of results for database operations.
 *
 * <p>There is no requirement that a new or distinct result be returned each
 * time the supplier is invoked.
 *
 * @param <T> the type of results supplied by this supplier
 *
 * @author Tuukka Lehtonen
 * @since 1.22.1 & 1.24.0
 */
@FunctionalInterface
public interface DbSupplier<T> {

    /**
     * Performs this operation on the given argument.
     *
     * @param t the input argument
     */
    T get() throws DatabaseException;

}
