/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.exception;

import org.simantics.db.Resource;

public class NoSingleResultException extends AssumptionException {

    private static final long serialVersionUID = 1647209154838034514L;

    private final int resultCount;

    public NoSingleResultException(String message, Throwable cause) {
        super(message, cause);
        this.resultCount = -1;
    }

    public NoSingleResultException(String message, int ... rs) {
        super(message, rs);
        this.resultCount = -1;
    }

    public NoSingleResultException(String message) {
        super(message);
        this.resultCount = -1;
    }

    public NoSingleResultException(String message, Resource ... resources) {
        super(message, resources);
        this.resultCount = -1;
    }

    public NoSingleResultException(String message, int resultCount, Throwable cause) {
        super(message + " [resultCount=" + resultCount + "]", cause);
        this.resultCount = resultCount;
    }

    public NoSingleResultException(String message, int resultCount, int ... rs) {
        super(message + " [resultCount=" + resultCount + "]", rs);
        this.resultCount = resultCount;
    }

    public NoSingleResultException(String message, int resultCount) {
        super(message + " [resultCount=" + resultCount + "]");
        this.resultCount = resultCount;
    }

    public NoSingleResultException(String message, int resultCount, Resource ... resources) {
        super(message + " [resultCount=" + resultCount + "]", resources);
        this.resultCount = resultCount;
    }

    public int getResultCount() {
        return resultCount;
    }
}
