/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import org.simantics.db.service.VirtualGraphSupport;


/**
 * Not intended to be implemented by clients.
 * 
 * @author Antti Villberg
 * 
 * @see VirtualGraphSupport
 */
public interface VirtualGraph {

    public enum Persistency {
        MEMORY("M"), WORKSPACE("W");
        final private String id;
        Persistency(String id) {
        	this.id = id;
        }
        public String identifier() {
        	return id;
        }
    }
        
    void register(VirtualGraphSource source);
    Persistency getPersistency();
    String getIdentifier();

}
